/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.energybar;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.threetag.palladium.network.SetEnergyBarMessage;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;
import net.threetag.palladium.power.energybar.EnergyBarReference;

public class EnergyBar {
    private final IPowerHolder powerHolder;
    private final EnergyBarConfiguration configuration;
    private int value;
    private int maxValue;
    private int overriddenMaxValue = -1;

    public EnergyBar(IPowerHolder powerHolder, EnergyBarConfiguration configuration) {
        this.powerHolder = powerHolder;
        this.configuration = configuration;
    }

    public void tick(class_1309 entity) {
        if (this.configuration.getSyncedValue() != null) {
            int synced = this.configuration.getSyncedValue().get((class_1297)entity);
            if (this.value != synced) {
                this.set(synced);
            }
        } else {
            int increase = this.configuration.getAutoIncrease();
            if (increase != 0 && entity.field_6012 % this.configuration.getAutoIncreaseInterval() == 0) {
                this.add(increase);
            }
        }
        if (this.overriddenMaxValue > 0) {
            if (this.maxValue != this.overriddenMaxValue) {
                this.setMax(this.overriddenMaxValue);
            }
        } else {
            int syncedMax = this.configuration.getMaxValue().get((class_1297)entity);
            if (this.maxValue != syncedMax) {
                this.setMax(syncedMax);
            }
        }
    }

    public void set(int value) {
        int prevValue = this.value;
        this.value = class_3532.method_15340((int)value, (int)0, (int)this.getMax());
        if (prevValue != this.value) {
            this.sync();
        }
    }

    public int get() {
        return this.value;
    }

    public int add(int value) {
        int prevValue = this.value;
        this.value = class_3532.method_15340((int)(this.value + value), (int)0, (int)this.getMax());
        if (prevValue != this.value) {
            this.sync();
        }
        return this.value;
    }

    public void setOverriddenMaxValue(int max) {
        int prev = this.overriddenMaxValue;
        this.overriddenMaxValue = Math.max(max, -1);
        if (prev != this.overriddenMaxValue) {
            if (this.value > this.getMax()) {
                this.value = this.getMax();
            }
            this.sync();
        }
    }

    public void setMax(int max) {
        int prevValue = this.maxValue;
        this.maxValue = Math.max(1, max);
        if (prevValue != this.value) {
            this.sync();
        }
    }

    public int getMax() {
        return this.maxValue;
    }

    public EnergyBarConfiguration getConfiguration() {
        return this.configuration;
    }

    private void sync() {
        if (!this.powerHolder.getEntity().method_37908().field_9236) {
            SetEnergyBarMessage msg = new SetEnergyBarMessage(this.powerHolder.getEntity().method_5628(), new EnergyBarReference(this.powerHolder.getPower().getId(), this.configuration.getName()), this.value, this.maxValue);
            class_1309 class_13092 = this.powerHolder.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                msg.sendToTrackingAndSelf(player);
            } else {
                msg.sendToTracking((class_1297)this.powerHolder.getEntity());
            }
        }
    }

    public class_2487 toNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Value", this.value);
        nbt.method_10569("MaxValue", this.maxValue);
        nbt.method_10569("OverriddenMaxValue", this.overriddenMaxValue);
        return nbt;
    }

    public void fromNBT(class_2487 nbt) {
        this.set(nbt.method_10550("Value"));
        this.setMax(nbt.method_10550("MaxValue"));
        this.overriddenMaxValue = nbt.method_10550("OverriddenMaxValue");
    }
}

