/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.energybar;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.energybar.EnergyBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyBarReference {
    @Nullable
    private final class_2960 powerId;
    @NotNull
    private final String energyBarName;

    public EnergyBarReference(@Nullable class_2960 powerId, @NotNull String energyBarName) {
        this.powerId = powerId;
        this.energyBarName = energyBarName;
    }

    public static EnergyBarReference fromString(String parse) {
        String[] s = parse.split("#", 2);
        if (s.length == 1) {
            return new EnergyBarReference(null, s[0]);
        }
        return new EnergyBarReference(new class_2960(s[0]), s[1]);
    }

    @Nullable
    public class_2960 getPowerId() {
        return this.powerId;
    }

    @NotNull
    public String getEnergyBarName() {
        return this.energyBarName;
    }

    @Nullable
    public EnergyBar getEntry(class_1309 entity) {
        return this.getEntry(entity, null);
    }

    @Nullable
    public EnergyBar getEntry(class_1309 entity, @Nullable IPowerHolder powerHolder) {
        if (this.powerId != null) {
            IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
            Power power = PowerManager.getInstance(entity.method_37908()).getPower(this.powerId);
            powerHolder = power != null && handler != null ? handler.getPowerHolder(power) : null;
        }
        if (powerHolder != null) {
            return powerHolder.getEnergyBars().get(this.energyBarName);
        }
        return null;
    }

    public Optional<EnergyBar> optional(class_1309 entity, @Nullable IPowerHolder powerHolder) {
        return Optional.ofNullable(this.getEntry(entity, powerHolder));
    }

    public void toBuffer(class_2540 buf) {
        buf.method_43826((Object)this.powerId, (buf1, resourceLocation) -> buf.method_10812(resourceLocation));
        buf.method_10814(this.energyBarName);
    }

    public static EnergyBarReference fromBuffer(class_2540 buf) {
        return new EnergyBarReference((class_2960)buf.method_43827(class_2540::method_10810), buf.method_19772());
    }

    public String toString() {
        if (this.powerId == null) {
            return this.energyBarName;
        }
        return String.valueOf(this.powerId) + "#" + this.energyBarName;
    }

    public int hashCode() {
        return Objects.hash(this.powerId, this.energyBarName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnergyBarReference)) {
            return false;
        }
        EnergyBarReference that = (EnergyBarReference)o;
        return Objects.equals(this.powerId, that.powerId) && Objects.equals(this.energyBarName, that.energyBarName);
    }
}

