/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_3518;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.IntegerProperty;
import org.jetbrains.annotations.Nullable;

public abstract class EntityDependentInteger {
    public abstract int get(class_1297 var1);

    public boolean isDynamic() {
        return true;
    }

    public static EntityDependentInteger staticValue(int value) {
        return new Static(value);
    }

    public static EntityDependentInteger score(String objectiveName, int fallbackValue) {
        return new Score(objectiveName, fallbackValue);
    }

    public static EntityDependentInteger palladiumProperty(String propertyName, int fallbackValue) {
        return new PalladiumProperty(propertyName, fallbackValue);
    }

    public static EntityDependentInteger fromJson(JsonElement jsonElement, String memberName) {
        if (jsonElement.isJsonPrimitive()) {
            return EntityDependentInteger.staticValue(class_3518.method_15257((JsonElement)jsonElement, (String)memberName));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)memberName);
            String type = class_3518.method_15265((JsonObject)json, (String)"type");
            if (type.equalsIgnoreCase("score")) {
                return EntityDependentInteger.score(class_3518.method_15265((JsonObject)json, (String)"objective"), class_3518.method_15282((JsonObject)json, (String)"fallback", (int)0));
            }
            if (type.equalsIgnoreCase("palladium_property")) {
                return EntityDependentInteger.palladiumProperty(class_3518.method_15265((JsonObject)json, (String)"property"), class_3518.method_15282((JsonObject)json, (String)"fallback", (int)0));
            }
            throw new JsonParseException("Unknown type " + type + ", must be 'score' or 'palladium_property'");
        }
        throw new JsonParseException(memberName + " must be either a primitive integer, or a JsonObject");
    }

    public abstract JsonElement toJson();

    @Nullable
    public static EntityDependentInteger fromNBT(class_2520 tag) {
        if (tag instanceof class_2497) {
            class_2497 intTag = (class_2497)tag;
            return EntityDependentInteger.staticValue(intTag.method_10701());
        }
        if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            String type = compoundTag.method_10558("Type");
            if (type.equalsIgnoreCase("score")) {
                return EntityDependentInteger.score(compoundTag.method_10558("Objective"), compoundTag.method_10550("Fallback"));
            }
            if (type.equalsIgnoreCase("palladium_property")) {
                return EntityDependentInteger.palladiumProperty(compoundTag.method_10558("Property"), compoundTag.method_10550("Fallback"));
            }
        }
        return null;
    }

    public abstract class_2520 toNBT();

    public static EntityDependentInteger fromBuffer(class_2540 buf) {
        int type = buf.readInt();
        if (type == 0) {
            return EntityDependentInteger.staticValue(buf.readInt());
        }
        if (type == 1) {
            return EntityDependentInteger.score(buf.method_19772(), buf.readInt());
        }
        return EntityDependentInteger.palladiumProperty(buf.method_19772(), buf.readInt());
    }

    public abstract void toBuffer(class_2540 var1);

    private static class Static
    extends EntityDependentInteger {
        private final int value;

        public Static(int value) {
            this.value = value;
        }

        @Override
        public int get(class_1297 entity) {
            return this.value;
        }

        @Override
        public boolean isDynamic() {
            return false;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive((Number)this.value);
        }

        @Override
        public class_2520 toNBT() {
            return class_2497.method_23247((int)this.value);
        }

        @Override
        public void toBuffer(class_2540 buf) {
            buf.writeInt(0);
            buf.writeInt(this.value);
        }
    }

    private static class Score
    extends EntityDependentInteger {
        private final String objectiveName;
        private final int fallbackValue;

        public Score(String objectiveName, int fallbackValue) {
            this.objectiveName = objectiveName;
            this.fallbackValue = fallbackValue;
        }

        @Override
        public int get(class_1297 entity) {
            class_269 scoreboard = entity.method_37908().method_8428();
            class_266 objective = scoreboard.method_1170(this.objectiveName);
            if (objective != null) {
                Map scores = scoreboard.method_1166(entity.method_5820());
                return scores.containsKey(objective) ? ((class_267)scores.get(objective)).method_1126() : this.fallbackValue;
            }
            return this.fallbackValue;
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "score");
            json.addProperty("objective", this.objectiveName);
            if (this.fallbackValue != 0) {
                json.addProperty("fallback", (Number)this.fallbackValue);
            }
            return json;
        }

        @Override
        public class_2520 toNBT() {
            class_2487 tag = new class_2487();
            tag.method_10582("Type", "score");
            tag.method_10582("Objective", this.objectiveName);
            tag.method_10569("Fallback", this.fallbackValue);
            return tag;
        }

        @Override
        public void toBuffer(class_2540 buf) {
            buf.writeInt(1);
            buf.method_10814(this.objectiveName);
            buf.writeInt(this.fallbackValue);
        }
    }

    private static class PalladiumProperty
    extends EntityDependentInteger {
        private final String propertyName;
        private final int fallbackValue;

        public PalladiumProperty(String propertyName, int fallbackValue) {
            this.propertyName = propertyName;
            this.fallbackValue = fallbackValue;
        }

        @Override
        public int get(class_1297 entity) {
            EntityPropertyHandler handler;
            net.threetag.palladium.util.property.PalladiumProperty<?> property;
            Optional<EntityPropertyHandler> opt = EntityPropertyHandler.getHandler(entity);
            if (opt.isPresent() && (property = (handler = opt.get()).getPropertyByName(this.propertyName)) instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                Integer result = handler.get(integerProperty);
                return result == null ? this.fallbackValue : result;
            }
            return this.fallbackValue;
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "palladium_property");
            json.addProperty("property", this.propertyName);
            if (this.fallbackValue != 0) {
                json.addProperty("fallback", (Number)this.fallbackValue);
            }
            return json;
        }

        @Override
        public class_2520 toNBT() {
            class_2487 tag = new class_2487();
            tag.method_10582("Type", "palladium_property");
            tag.method_10582("Property", this.propertyName);
            tag.method_10569("Fallback", this.fallbackValue);
            return tag;
        }

        @Override
        public void toBuffer(class_2540 buf) {
            buf.writeInt(2);
            buf.method_10814(this.propertyName);
            buf.writeInt(this.fallbackValue);
        }
    }
}

