/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.function.Predicate;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.threetag.palladium.entity.EffectEntity;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.MathUtil;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    public static boolean isMoving(class_1297 entity) {
        if (entity instanceof PalladiumEntityExtension) {
            PalladiumEntityExtension ext = (PalladiumEntityExtension)entity;
            return ext.palladium$getLastTickPos().method_1022(entity.method_19538()) != 0.0;
        }
        return false;
    }

    public static class_243 getLookVector(class_1297 entity) {
        return MathUtil.calculateViewVector(entity.method_36455(), entity.method_5791());
    }

    public static class_243 getLookVector(class_1297 entity, float partialTicks) {
        float f;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            f = class_3532.method_16439((float)partialTicks, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
        } else {
            f = entity.method_5791();
        }
        float headRot = f;
        return MathUtil.calculateViewVector(entity.method_5695(partialTicks), headRot);
    }

    public static class_239 rayTraceWithEntities(class_1297 entityIn, double distance, class_3959.class_3960 blockModeIn, class_3959.class_242 fluidModeIn) {
        return EntityUtil.rayTraceWithEntities(entityIn, null, null, distance, blockModeIn, fluidModeIn, e -> true);
    }

    public static class_239 rayTraceWithEntities(class_1297 entityIn, @Nullable class_243 startVec, @Nullable class_243 endVec, double distance, class_3959.class_3960 blockModeIn, class_3959.class_242 fluidModeIn, Predicate<class_1297> entityPredicate) {
        class_243 lookVec = EntityUtil.getLookVector(entityIn);
        startVec = startVec == null ? entityIn.method_19538().method_1031(0.0, (double)entityIn.method_5751(), 0.0) : startVec;
        endVec = endVec == null ? startVec.method_1019(lookVec.method_1021(distance)) : endVec;
        class_3965 blockResult = entityIn.method_37908().method_17742(new class_3959(startVec, endVec, blockModeIn, fluidModeIn, entityIn));
        class_3966 entityResult = null;
        int i = 0;
        while ((double)i < distance * 2.0 && entityResult == null) {
            float scale = (float)i / 2.0f;
            class_243 pos = startVec.method_1019(lookVec.method_1021((double)scale));
            class_243 min = pos.method_1031(0.25, 0.25, 0.25);
            class_243 max = pos.method_1031(-0.25, -0.25, -0.25);
            for (class_1297 entity : entityIn.method_37908().method_8335(entityIn, new class_238(min.field_1352, min.field_1351, min.field_1350, max.field_1352, max.field_1351, max.field_1350))) {
                if (!EntityUtil.canBeTraced(entity) || !entityPredicate.test(entity)) continue;
                entityResult = new class_3966(entity, pos);
                break;
            }
            ++i;
        }
        if (entityResult != null && entityResult.method_17784().method_1022(startVec) <= blockResult.method_17784().method_1022(startVec)) {
            return entityResult;
        }
        return blockResult;
    }

    public static boolean canBeTraced(class_1297 entity) {
        if (entity instanceof class_1295) {
            return false;
        }
        if (entity instanceof TrailSegmentEntity) {
            return false;
        }
        return !(entity instanceof EffectEntity);
    }
}

