/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import org.slf4j.Logger;

public abstract class LegacySupportJsonReloadListener
extends class_4080<Map<class_2960, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;
    private final String legacyDirectory;

    public LegacySupportJsonReloadListener(Gson gson, String directory, String legacyDirectory) {
        this.gson = gson;
        this.directory = directory;
        this.legacyDirectory = legacyDirectory;
    }

    protected Map<class_2960, JsonElement> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap map = Maps.newHashMap();
        boolean foundLegacy = false;
        for (int m = 0; m < 2; ++m) {
            String path = m == 0 ? this.legacyDirectory : this.directory;
            int i = path.length() + 1;
            for (Map.Entry entry : resourceManager.method_14488(path, p_215600_ -> p_215600_.method_12832().endsWith(PATH_SUFFIX)).entrySet()) {
                if (m == 0) {
                    foundLegacy = true;
                }
                class_2960 resourcelocation = (class_2960)entry.getKey();
                String s = resourcelocation.method_12832();
                class_2960 id = new class_2960(resourcelocation.method_12836(), s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
                try {
                    BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                    try {
                        JsonElement jsonelement = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                        if (jsonelement != null) {
                            JsonElement jsonelement1 = map.put(id, jsonelement);
                            if (jsonelement1 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                        }
                        LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)resourcelocation);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                    LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, resourcelocation, jsonparseexception});
                }
            }
        }
        if (foundLegacy) {
            AddonPackLog.warning("Files were found in deprecated folder: '" + this.legacyDirectory + "'. Please switch to '" + this.directory + "'!", new Object[0]);
        }
        return map;
    }
}

