/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3518;
import net.threetag.palladium.util.PlayerUtil;

public class SkinTypedValue<T> {
    private final T normal;
    private final T slim;

    public SkinTypedValue(T value) {
        this.slim = value;
        this.normal = this.slim;
    }

    public SkinTypedValue(T normal, T slim) {
        this.normal = normal;
        this.slim = slim;
    }

    public T getNormal() {
        return this.normal;
    }

    public T getSlim() {
        return this.slim;
    }

    public T get(boolean slim) {
        return slim ? this.getSlim() : this.getNormal();
    }

    public T get(class_1297 entity) {
        class_1657 player;
        return this.get(entity instanceof class_1657 && PlayerUtil.hasSmallArms(player = (class_1657)entity));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTypedValue)) {
            return false;
        }
        SkinTypedValue that = (SkinTypedValue)o;
        return Objects.equals(this.normal, that.normal) && Objects.equals(this.slim, that.slim);
    }

    public int hashCode() {
        return Objects.hash(this.normal, this.slim);
    }

    public String toString() {
        return "SkinTypedValue{normal=" + String.valueOf(this.normal) + ", slim=" + String.valueOf(this.slim) + "}";
    }

    public static <T> SkinTypedValue<T> fromJSON(JsonElement jsonElement, Function<JsonElement, T> parser) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            if (class_3518.method_15294((JsonObject)json, (String)"normal") && class_3518.method_15294((JsonObject)json, (String)"slim")) {
                return new SkinTypedValue<T>(parser.apply(json.get("normal")), parser.apply(json.get("slim")));
            }
            return new SkinTypedValue<T>(parser.apply(jsonElement));
        }
        return new SkinTypedValue<T>(parser.apply(jsonElement));
    }

    public JsonElement toJson(Function<T, JsonElement> serializer) {
        if (this.normal == this.slim) {
            return serializer.apply(this.normal);
        }
        JsonObject json = new JsonObject();
        json.add("normal", serializer.apply(this.normal));
        json.add("slim", serializer.apply(this.slim));
        return json;
    }
}

