/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.context;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContextType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataContext {
    private final Map<DataContextType<?>, Object> values = new HashMap();

    private DataContext() {
    }

    public static DataContext create() {
        return new DataContext();
    }

    public static DataContext forEntity(class_1297 entity) {
        return DataContext.create().with(DataContextType.ENTITY, entity).with(DataContextType.LEVEL, entity.method_37908());
    }

    public static DataContext forArmorInSlot(class_1309 entity, class_1304 slot) {
        return DataContext.forEntity((class_1297)entity).with(DataContextType.SLOT, slot).with(DataContextType.ITEM, entity.method_6118(slot));
    }

    public static DataContext forItem(class_1297 entity, class_1799 stack) {
        return DataContext.forEntity(entity).with(DataContextType.ITEM, stack);
    }

    public static DataContext forPower(class_1309 entity, IPowerHolder powerHolder) {
        DataContext context = DataContext.forEntity((class_1297)entity);
        if (powerHolder != null) {
            context.with(DataContextType.POWER_HOLDER, powerHolder);
            context.with(DataContextType.POWER, powerHolder.getPower());
        }
        return context;
    }

    public static DataContext forAbility(class_1309 entity, AbilityInstance abilityInstance) {
        DataContext context = DataContext.forEntity((class_1297)entity);
        if (abilityInstance != null) {
            context.with(DataContextType.ABILITY, abilityInstance);
            context.with(DataContextType.POWER_HOLDER, abilityInstance.getHolder());
            context.with(DataContextType.POWER, abilityInstance.getHolder().getPower());
        }
        return context;
    }

    public <T> DataContext with(DataContextType<T> type, T value) {
        this.values.put(type, value);
        return this;
    }

    public <T> T get(DataContextType<T> type) {
        return (T)this.values.get(type);
    }

    public boolean has(DataContextType<?> type) {
        return this.values.containsKey(type);
    }

    public DataContext copy() {
        DataContext context = new DataContext();
        context.values.putAll(this.values);
        return context;
    }

    @Nullable
    public class_1297 getEntity() {
        return this.get(DataContextType.ENTITY);
    }

    @Nullable
    public class_1309 getLivingEntity() {
        class_1309 living;
        class_1297 entity = this.getEntity();
        return entity instanceof class_1309 ? (living = (class_1309)entity) : null;
    }

    @Nullable
    public class_1657 getPlayer() {
        class_1657 player;
        class_1297 entity = this.getEntity();
        return entity instanceof class_1657 ? (player = (class_1657)entity) : null;
    }

    @Nullable
    public class_1937 getLevel() {
        return this.get(DataContextType.LEVEL);
    }

    @NotNull
    public class_1799 getItem() {
        return this.has(DataContextType.ITEM) ? this.get(DataContextType.ITEM) : class_1799.field_8037;
    }

    @Nullable
    public class_1304 getSlot() {
        return this.get(DataContextType.SLOT);
    }

    @Nullable
    public AbilityInstance getAbility() {
        return this.get(DataContextType.ABILITY);
    }

    @Nullable
    public Power getPower() {
        return this.get(DataContextType.POWER);
    }

    @Nullable
    public IPowerHolder getPowerHolder() {
        return this.get(DataContextType.POWER_HOLDER);
    }
}

