/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.icon.TexturedIcon;
import org.jetbrains.annotations.NotNull;

public class CompoundIcon
implements IIcon {
    private final LinkedList<IIcon> icons = new LinkedList();

    @Override
    public void draw(class_310 mc, class_332 guiGraphics, DataContext context, int x, int y, int width, int height) {
        for (IIcon icon : this.icons) {
            icon.draw(mc, guiGraphics, context, x, y, width, height);
        }
    }

    public IconSerializer<CompoundIcon> getSerializer() {
        return (IconSerializer)IconSerializers.COMPOUND.get();
    }

    public static class Serializer
    extends IconSerializer<CompoundIcon> {
        @Override
        @NotNull
        public CompoundIcon fromJSON(JsonObject json) {
            JsonArray icons = class_3518.method_15261((JsonObject)json, (String)"icons");
            CompoundIcon compoundIcon = new CompoundIcon();
            for (JsonElement jsonElement : icons) {
                IIcon icon = IconSerializer.parseJSON(jsonElement);
                compoundIcon.icons.add(icon);
            }
            return compoundIcon;
        }

        @Override
        public CompoundIcon fromNBT(class_2487 nbt) {
            class_2499 listTag = nbt.method_10554("Icons", 10);
            CompoundIcon compoundIcon = new CompoundIcon();
            for (int i = 0; i < listTag.size(); ++i) {
                IIcon icon = IconSerializer.parseNBT(listTag.method_10602(i));
                compoundIcon.icons.add(icon);
            }
            return compoundIcon;
        }

        @Override
        public JsonObject toJSON(CompoundIcon icon) {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (IIcon i : icon.icons) {
                jsonArray.add(IconSerializer.serializeJSON(i));
            }
            return jsonObject;
        }

        @Override
        public class_2487 toNBT(CompoundIcon icon) {
            class_2487 nbt = new class_2487();
            class_2499 listTag = new class_2499();
            for (IIcon i : icon.icons) {
                listTag.add((Object)IconSerializer.serializeNBT(i));
            }
            nbt.method_10566("Icons", (class_2520)listTag);
            return nbt;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Compound Icon");
            builder.setDescription("Let's you merge multiple icons into one.");
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(IconSerializer.serializeJSON(new ItemIcon((class_1935)class_1802.field_8279)));
            jsonArray.add(IconSerializer.serializeJSON(new TexturedIcon(new class_2960("example:textures/icons/my_icon.png"))));
            builder.addProperty("icons", IIcon[].class).description("Array of the icons you want to merge").required().exampleJson((JsonElement)jsonArray);
        }
    }
}

