/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.icon.TexturedIcon;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.registry.PalladiumRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class IconSerializer<T extends IIcon>
implements IDocumentedConfigurable {
    public static final PalladiumRegistry<IconSerializer> REGISTRY = PalladiumRegistry.create(IconSerializer.class, (class_2960)Palladium.id("icon_serializers"));

    public static IIcon parseJSON(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String input = json.getAsString();
            if (input.endsWith(".png")) {
                return new TexturedIcon(new class_2960(input));
            }
            if (input.startsWith("#")) {
                return new TexturedIcon(TextureReference.parse(input));
            }
            class_2960 id = new class_2960(json.getAsString());
            if (!class_7923.field_41178.method_10250(id)) {
                throw new JsonParseException("Unknown item '" + json.getAsString() + "'");
            }
            return new ItemIcon((class_1935)class_7923.field_41178.method_10223(id));
        }
        if (json.isJsonObject()) {
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)json.getAsJsonObject(), (String)"type"));
            if (!REGISTRY.containsKey(id)) {
                throw new JsonParseException("Unknown icon type '" + String.valueOf(id) + "'");
            }
            IconSerializer serializer = (IconSerializer)REGISTRY.get(id);
            return Objects.requireNonNull(serializer).fromJSON(json.getAsJsonObject());
        }
        throw new JsonParseException("Icon must either be a string or an object");
    }

    public static JsonElement serializeJSON(IIcon icon) {
        if (icon instanceof ItemIcon) {
            ItemIcon itemIcon = (ItemIcon)icon;
            if (itemIcon.stack.method_7947() == 1) {
                return new JsonPrimitive(class_7923.field_41178.method_10221((Object)itemIcon.stack.method_7909()).toString());
            }
        }
        if (icon instanceof TexturedIcon) {
            TexturedIcon texturedIcon = (TexturedIcon)icon;
            if (texturedIcon.tint == null) {
                return new JsonPrimitive(texturedIcon.texture.toString());
            }
        }
        IconSerializer<?> serializer = icon.getSerializer();
        JsonObject json = serializer.toJSON(icon);
        JsonObject json2 = new JsonObject();
        json2.addProperty("type", Objects.requireNonNull(REGISTRY.getKey(serializer)).toString());
        return GsonUtil.merge(json2, json);
    }

    public static IIcon parseNBT(class_2487 tag) {
        class_2960 id = new class_2960(tag.method_10558("Type"));
        if (!REGISTRY.containsKey(id)) {
            return null;
        }
        IconSerializer serializer = (IconSerializer)REGISTRY.get(id);
        return Objects.requireNonNull(serializer).fromNBT(tag);
    }

    public static class_2487 serializeNBT(IIcon icon) {
        IconSerializer<?> serializer = icon.getSerializer();
        class_2487 nbt = serializer.toNBT(icon);
        nbt.method_10582("Type", Objects.requireNonNull(REGISTRY.getKey(serializer)).toString());
        return nbt;
    }

    public static HTMLBuilder documentationBuilder() {
        return new HTMLBuilder(new class_2960("palladium", "icons"), "Icons").add(HTMLBuilder.heading("Icons")).addDocumentationSettings(REGISTRY.getValues().stream().sorted(Comparator.comparing(o -> o.getId().toString())).collect(Collectors.toList()));
    }

    @NotNull
    public abstract T fromJSON(JsonObject var1);

    public abstract T fromNBT(class_2487 var1);

    public abstract JsonObject toJSON(T var1);

    public abstract class_2487 toNBT(T var1);

    @Override
    public class_2960 getId() {
        return REGISTRY.getKey((Object)this);
    }
}

