/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.GuiUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;

public class ItemIcon
implements IIcon {
    public final class_1799 stack;

    public ItemIcon(class_1799 stack) {
        this.stack = stack;
    }

    public ItemIcon(class_1935 itemLike) {
        this.stack = new class_1799(itemLike);
    }

    @Override
    public void draw(class_310 mc, class_332 guiGraphics, DataContext context, int x, int y, int width, int height) {
        class_1799 item;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 100.0);
        if (width != 16 || height != 16) {
            int s = Math.min(width, height);
            guiGraphics.method_51448().method_22905((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        if ((item = this.stack).method_7960()) {
            class_1799 contextItem = context.getItem();
            item = !contextItem.method_7960() ? contextItem : new class_1799((class_1935)class_1802.field_8077);
        }
        GuiUtil.drawItem(guiGraphics, item, 0, true, null);
        guiGraphics.method_51448().method_22909();
    }

    public IconSerializer<ItemIcon> getSerializer() {
        return (IconSerializer)IconSerializers.ITEM.get();
    }

    public String toString() {
        return "ItemIcon{stack=" + String.valueOf(this.stack) + "}";
    }

    public static class Serializer
    extends IconSerializer<ItemIcon> {
        @Override
        @NotNull
        public ItemIcon fromJSON(JsonObject json) {
            return new ItemIcon(json.has("item") ? GsonUtil.readItemStack((JsonElement)json) : class_1799.field_8037);
        }

        @Override
        public ItemIcon fromNBT(class_2487 nbt) {
            return new ItemIcon(class_1799.method_7915((class_2487)nbt));
        }

        @Override
        public JsonObject toJSON(ItemIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)icon.stack.method_7909()).toString());
            jsonObject.addProperty("count", (Number)icon.stack.method_7947());
            return jsonObject;
        }

        @Override
        public class_2487 toNBT(ItemIcon icon) {
            return icon.stack.method_7953(new class_2487());
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Item Icon");
            builder.setDescription("Uses an item as an icon.");
            builder.addProperty("item", class_2960.class).description("ID of the item that's supposed to be displayed. If you leave it out, it will display the item from the current context (if given).").fallback(new class_2960("minecraft:air")).exampleJson((JsonElement)new JsonPrimitive("minecraft:apple"));
        }
    }
}

