/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.GuiUtil;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import org.jetbrains.annotations.NotNull;

public record ItemInSlotIcon(PlayerSlot slot) implements IIcon
{
    @Override
    public void draw(class_310 mc, class_332 guiGraphics, DataContext context, int x, int y, int width, int height) {
        class_1799 found;
        class_4587 stack = guiGraphics.method_51448();
        stack.method_22903();
        stack.method_22904((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 100.0);
        if (width != 16 || height != 16) {
            int s = Math.min(width, height);
            stack.method_22905((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        class_1799 item = new class_1799((class_1935)class_1802.field_8077);
        List<class_1799> items = this.slot.getItems(context.getLivingEntity());
        if (!items.isEmpty() && !(found = items.get(0)).method_7960()) {
            item = found;
        }
        GuiUtil.drawItem(guiGraphics, item, 0, true, null);
        stack.method_22909();
    }

    public IconSerializer<ItemInSlotIcon> getSerializer() {
        return (IconSerializer)IconSerializers.ITEM_IN_SLOT.get();
    }

    @Override
    public String toString() {
        return "ItemIcon{slot=" + this.slot.toString() + "}";
    }

    public static class Serializer
    extends IconSerializer<ItemInSlotIcon> {
        @Override
        @NotNull
        public ItemInSlotIcon fromJSON(JsonObject json) {
            return new ItemInSlotIcon(PlayerSlot.get(class_3518.method_15265((JsonObject)json, (String)"slot")));
        }

        @Override
        public ItemInSlotIcon fromNBT(class_2487 nbt) {
            return new ItemInSlotIcon(PlayerSlot.get(nbt.method_10558("Slot")));
        }

        @Override
        public JsonObject toJSON(ItemInSlotIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("slot", icon.slot.toString());
            return jsonObject;
        }

        @Override
        public class_2487 toNBT(ItemInSlotIcon icon) {
            class_2487 tag = new class_2487();
            tag.method_10582("Slot", icon.slot.toString());
            return tag;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Item in Slot Icon");
            builder.setDescription("Uses the item that's in the specified slot.");
            builder.addProperty("slot", String.class).description("Name of the slot.").required().exampleJson((JsonElement)new JsonPrimitive("chest"));
        }
    }
}

