/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;

public class AccessorySlotProperty
extends PalladiumProperty<AccessorySlot> {
    public AccessorySlotProperty(String key) {
        super(key);
    }

    @Override
    public AccessorySlot fromJSON(JsonElement jsonElement) {
        AccessorySlot slot = AccessorySlot.getSlotByName(GsonUtil.convertToResourceLocation(jsonElement, this.getKey()));
        if (slot == null) {
            throw new JsonParseException("Unknown accessory slot '" + jsonElement.getAsString() + "'");
        }
        return slot;
    }

    @Override
    public JsonElement toJSON(AccessorySlot value) {
        return new JsonPrimitive(value.getName().toString());
    }

    @Override
    public AccessorySlot fromNBT(class_2520 tag, AccessorySlot defaultValue) {
        if (tag instanceof class_2519) {
            class_2519 stringTag = (class_2519)tag;
            return AccessorySlot.getSlotByName(new class_2960(stringTag.method_10714()));
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(AccessorySlot value) {
        return class_2519.method_23256((String)value.getName().toString());
    }

    @Override
    public AccessorySlot fromBuffer(class_2540 buf) {
        return AccessorySlot.getSlotByName(buf.method_10810());
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        buf.method_10812(((AccessorySlot)value).getName());
    }

    @Override
    public String getString(AccessorySlot value) {
        return value != null ? value.getName().toString() : null;
    }

    @Override
    public String getPropertyType() {
        return "accessory_slot";
    }
}

