/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.property.PalladiumProperty;

public class BodyPartListProperty
extends PalladiumProperty<List<BodyPart>> {
    public BodyPartListProperty(String key) {
        super(key);
    }

    @Override
    public List<BodyPart> fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            String name = jsonElement.getAsString();
            if (name.equalsIgnoreCase("all")) {
                return Arrays.asList(BodyPart.values());
            }
            return Collections.singletonList(BodyPart.fromJson(name));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<BodyPart> list = new ArrayList<BodyPart>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(BodyPart.fromJson(jsonArray.get(i).getAsString()));
        }
        return list;
    }

    @Override
    public JsonElement toJSON(List<BodyPart> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.get(0).getName());
        }
        JsonArray jsonArray = new JsonArray();
        for (BodyPart bodyPart : value) {
            jsonArray.add((JsonElement)new JsonPrimitive(bodyPart.getName()));
        }
        return jsonArray;
    }

    @Override
    public List<BodyPart> fromNBT(class_2520 tag, List<BodyPart> defaultValue) {
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            ArrayList<BodyPart> list = new ArrayList<BodyPart>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(BodyPart.byName(listTag.method_10608(i)));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(List<BodyPart> value) {
        class_2499 listTag = new class_2499();
        for (BodyPart part : value) {
            listTag.add((Object)class_2519.method_23256((String)part.getName()));
        }
        return listTag;
    }

    @Override
    public List<BodyPart> fromBuffer(class_2540 buf) {
        int amount = buf.readInt();
        ArrayList<BodyPart> list = new ArrayList<BodyPart>();
        for (int i = 0; i < amount; ++i) {
            list.add(BodyPart.byName(buf.method_19772()));
        }
        return list;
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        List list = (List)value;
        buf.writeInt(list.size());
        for (BodyPart part : list) {
            buf.method_10814(part.getName());
        }
    }

    @Override
    public String getString(List<BodyPart> value) {
        return Arrays.toString(value.stream().map(BodyPart::getName).toArray());
    }
}

