/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.threetag.palladium.util.property.PalladiumProperty;

public abstract class EnumPalladiumProperty<T>
extends PalladiumProperty<T> {
    public EnumPalladiumProperty(String key) {
        super(key);
    }

    public abstract T[] getValues();

    public abstract String getNameFromEnum(T var1);

    public T getByName(String name) {
        for (T value : this.getValues()) {
            if (!this.getNameFromEnum(value).equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    @Override
    public String getDescription() {
        Object desc = super.getDescription();
        if (!((String)desc).endsWith(".")) {
            desc = (String)desc + ".";
        }
        return (String)desc + " Possible values: " + Arrays.toString(Arrays.stream(this.getValues()).map(this::getNameFromEnum).toList().toArray());
    }

    @Override
    public T fromJSON(JsonElement jsonElement) {
        T value = this.getByName(jsonElement.getAsString());
        if (value == null) {
            throw new JsonParseException("Unknown " + this.getKey() + " '" + jsonElement.getAsString() + "'");
        }
        return value;
    }

    @Override
    public JsonElement toJSON(T value) {
        return new JsonPrimitive(this.getNameFromEnum(value));
    }

    @Override
    public T fromNBT(class_2520 tag, T defaultValue) {
        class_2519 stringTag;
        T value;
        if (tag instanceof class_2519 && (value = this.getByName((stringTag = (class_2519)tag).method_10714())) != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(T value) {
        return class_2519.method_23256((String)this.getNameFromEnum(value));
    }

    @Override
    public T fromBuffer(class_2540 buf) {
        return this.getByName(buf.method_19772());
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        buf.method_10814(this.getNameFromEnum(value));
    }
}

