/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.property.PalladiumProperty;

public class PlayerSlotListProperty
extends PalladiumProperty<List<PlayerSlot>> {
    public PlayerSlotListProperty(String key) {
        super(key);
    }

    @Override
    public List<PlayerSlot> fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return Collections.singletonList(PlayerSlot.get(jsonElement.getAsString()));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<PlayerSlot> list = new ArrayList<PlayerSlot>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(PlayerSlot.get(jsonArray.get(i).getAsString()));
        }
        return list;
    }

    @Override
    public JsonElement toJSON(List<PlayerSlot> value) {
        JsonArray jsonArray = new JsonArray();
        for (PlayerSlot s : value) {
            jsonArray.add(s.toString());
        }
        return jsonArray;
    }

    @Override
    public List<PlayerSlot> fromNBT(class_2520 tag, List<PlayerSlot> defaultValue) {
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            ArrayList<PlayerSlot> list = new ArrayList<PlayerSlot>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(PlayerSlot.get(listTag.method_10608(i)));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(List<PlayerSlot> value) {
        class_2499 listTag = new class_2499();
        for (PlayerSlot s : value) {
            listTag.add((Object)class_2519.method_23256((String)s.toString()));
        }
        return listTag;
    }

    @Override
    public List<PlayerSlot> fromBuffer(class_2540 buf) {
        ArrayList<PlayerSlot> list = new ArrayList<PlayerSlot>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            list.add(PlayerSlot.get(buf.method_19772()));
        }
        return list;
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        List strings = (List)value;
        buf.writeInt(strings.size());
        for (PlayerSlot slot : strings) {
            buf.method_10814(slot.toString());
        }
    }

    @Override
    public String getString(List<PlayerSlot> value) {
        return value == null ? null : Arrays.toString(value.toArray());
    }

    @Override
    public String getDescription() {
        Object desc = super.getDescription();
        if (!((String)desc).endsWith(".")) {
            desc = (String)desc + ".";
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.stream(class_1304.values()).map(class_1304::method_5923).toList());
        list.add("curios:back");
        list.add("curios:necklace");
        list.add("trinkets:chest/back");
        list.add("trinkets:chest/necklace");
        return (String)desc + " Example values: " + Arrays.toString(list.toArray());
    }
}

