/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.threetag.palladium.util.property.PalladiumProperty;
import org.jetbrains.annotations.Nullable;

public class PropertyManager {
    final Map<PalladiumProperty<?>, Object> defaultProperties = new LinkedHashMap();
    final Map<PalladiumProperty<?>, Object> values = new LinkedHashMap();
    Listener listener;

    public PropertyManager setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public <T> PropertyManager register(PalladiumProperty<T> property, T value) {
        this.defaultProperties.put(property, value);
        this.values.put(property, value);
        return this;
    }

    public boolean isRegistered(PalladiumProperty<?> property) {
        return this.defaultProperties.containsKey(property);
    }

    public <T> PropertyManager set(PalladiumProperty<T> property, @Nullable T value) {
        if (!this.defaultProperties.containsKey(property)) {
            throw new RuntimeException("Property " + property.getKey() + " was not registered!");
        }
        Object oldValue = this.values.get(property);
        this.values.put(property, value);
        if (this.listener != null) {
            this.listener.onChanged(property, oldValue, value);
        }
        return this;
    }

    public PropertyManager setRaw(PalladiumProperty property, @Nullable Object value) {
        if (!this.defaultProperties.containsKey(property)) {
            throw new RuntimeException("Property " + property.getKey() + " was not registered!");
        }
        Object oldValue = this.values.get(property);
        this.values.put(property, value);
        if (this.listener != null) {
            this.listener.onChanged(property, oldValue, value);
        }
        return this;
    }

    @Nullable
    public <T> T get(PalladiumProperty<T> property) {
        return (T)this.values.get(property);
    }

    @Nullable
    public <T> T getDefault(PalladiumProperty<T> property) {
        return (T)this.defaultProperties.get(property);
    }

    public <T> Optional<T> optional(PalladiumProperty<T> property) {
        return Optional.ofNullable(this.get(property));
    }

    public <T> T reset(PalladiumProperty<T> property) {
        Object oldValue = this.values.get(property);
        Object defVal = this.defaultProperties.get(property);
        this.values.put(property, defVal);
        if (this.listener != null) {
            this.listener.onChanged(property, oldValue, defVal);
        }
        return (T)this.defaultProperties.get(property);
    }

    public PalladiumProperty<?> getPropertyByName(String name) {
        for (PalladiumProperty<?> property : this.values.keySet()) {
            if (!property.getKey().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Map<PalladiumProperty<?>, Object> values() {
        return this.values;
    }

    public PropertyManager copy() {
        PropertyManager propertyManager = new PropertyManager();
        propertyManager.defaultProperties.putAll(this.defaultProperties);
        propertyManager.values.putAll(this.values);
        return propertyManager;
    }

    public void fromNBT(class_2487 nbt) {
        this.values.clear();
        for (PalladiumProperty<?> property : this.defaultProperties.keySet()) {
            if (nbt.method_10545(property.getKey())) {
                class_2519 stringTag;
                class_2520 tag = nbt.method_10580(property.getKey());
                if (tag instanceof class_2519 && (stringTag = (class_2519)tag).method_10714().equals("null")) {
                    this.values.put(property, null);
                    continue;
                }
                this.values.put(property, property.fromNBT(nbt.method_10580(property.getKey()), this.defaultProperties.get(property)));
                continue;
            }
            this.values.put(property, property.fromNBT(nbt.method_10580(property.getKey()), this.defaultProperties.get(property)));
        }
    }

    public class_2487 toNBT(boolean toDisk) {
        class_2487 nbt = new class_2487();
        for (PalladiumProperty<?> property : this.values.keySet()) {
            if (toDisk && !property.isPersistent()) continue;
            if (this.values.get(property) == null) {
                nbt.method_10566(property.getKey(), (class_2520)class_2519.method_23256((String)"null"));
                continue;
            }
            nbt.method_10566(property.getKey(), property.toNBT(this.values.get(property)));
        }
        return nbt;
    }

    public void toBuffer(class_2540 buf) {
        buf.writeInt(this.values.size());
        this.values.forEach((property, value) -> {
            buf.method_10814(property.getKey());
            buf.writeBoolean(value != null);
            if (value != null) {
                property.toBuffer(buf, value);
            }
        });
    }

    public void fromBuffer(class_2540 buf) {
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            PalladiumProperty<?> property = this.getPropertyByName(buf.method_19772());
            if (!buf.readBoolean() || property == null) continue;
            this.values.put(property, property.fromBuffer(buf));
        }
    }

    public void fromJSON(JsonObject json) {
        for (PalladiumProperty<?> property : this.defaultProperties.keySet()) {
            if (!class_3518.method_15294((JsonObject)json, (String)property.getKey())) continue;
            JsonElement jsonElement = json.get(property.getKey());
            if (jsonElement.isJsonPrimitive() && jsonElement.getAsString().equals("null")) {
                this.values.put(property, null);
                continue;
            }
            this.values.put(property, property.fromJSON(json.get(property.getKey())));
        }
    }

    public static interface Listener {
        public <T> void onChanged(PalladiumProperty<T> var1, T var2, T var3);
    }
}

