/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ResourceLocationListProperty
extends PalladiumProperty<List<class_2960>> {
    public ResourceLocationListProperty(String key) {
        super(key);
    }

    @Override
    public List<class_2960> fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return Collections.singletonList(new class_2960(jsonElement.getAsString()));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<class_2960> resourceLocations = new ArrayList<class_2960>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            resourceLocations.add(new class_2960(jsonArray.get(i).getAsString()));
        }
        return resourceLocations;
    }

    @Override
    public JsonElement toJSON(List<class_2960> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.toString());
        }
        JsonArray jsonArray = new JsonArray();
        for (class_2960 rl : value) {
            jsonArray.add(rl.toString());
        }
        return jsonArray;
    }

    @Override
    public List<class_2960> fromNBT(class_2520 tag, List<class_2960> defaultValue) {
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            ArrayList<class_2960> list = new ArrayList<class_2960>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(new class_2960(listTag.method_10608(i)));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(List<class_2960> value) {
        class_2499 listTag = new class_2499();
        for (class_2960 s : value) {
            listTag.add((Object)class_2519.method_23256((String)s.toString()));
        }
        return listTag;
    }

    @Override
    public List<class_2960> fromBuffer(class_2540 buf) {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            list.add(buf.method_10810());
        }
        return list;
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        List strings = (List)value;
        buf.writeInt(strings.size());
        for (class_2960 resourceLocation : strings) {
            buf.method_10812(resourceLocation);
        }
    }

    @Override
    public String getString(List<class_2960> value) {
        return value == null ? null : Arrays.toString(value.stream().map(class_2960::toString).toList().toArray());
    }
}

