/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.threetag.palladium.util.property.PalladiumProperty;

public class StringArrayProperty
extends PalladiumProperty<String[]> {
    public StringArrayProperty(String key) {
        super(key);
    }

    @Override
    public String[] fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new String[]{jsonElement.getAsString()};
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        String[] strings = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            strings[i] = jsonArray.get(i).getAsString();
        }
        return strings;
    }

    @Override
    public JsonElement toJSON(String[] value) {
        JsonArray jsonArray = new JsonArray();
        for (String s : value) {
            jsonArray.add(s);
        }
        return jsonArray;
    }

    @Override
    public String[] fromNBT(class_2520 tag, String[] defaultValue) {
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            String[] strings = new String[listTag.size()];
            for (int i = 0; i < listTag.size(); ++i) {
                strings[i] = listTag.method_10608(i);
            }
            return strings;
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(String[] value) {
        class_2499 listTag = new class_2499();
        for (String s : value) {
            listTag.add((Object)class_2519.method_23256((String)s));
        }
        return listTag;
    }

    @Override
    public String[] fromBuffer(class_2540 buf) {
        String[] strings = new String[buf.readInt()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = buf.method_19772();
        }
        return strings;
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        String[] strings = (String[])value;
        buf.writeInt(strings.length);
        for (String string : strings) {
            buf.method_10814(string);
        }
    }

    @Override
    public String getString(String[] value) {
        return value == null ? null : Arrays.toString(value);
    }

    @Override
    public String getPropertyType() {
        return "string_array";
    }
}

