/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.world;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_266;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.server.MinecraftServer;
import net.threetag.palladium.Palladium;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.NotNull;

public class TrackedScoresManager
extends class_4080<List<String>> {
    public static TrackedScoresManager INSTANCE;
    private final List<String> tracked = new ArrayList<String>();

    public static void init() {
        INSTANCE = new TrackedScoresManager();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_2960)Palladium.id("tracked_scores"), (class_3302)INSTANCE);
    }

    @NotNull
    protected List<String> prepare(class_3300 resourceManager, class_3695 profiler) {
        ArrayList<String> objectives = new ArrayList<String>();
        profiler.method_16065();
        for (String namespace : resourceManager.method_14487()) {
            profiler.method_15396(namespace);
            List list = resourceManager.method_14489(new class_2960(namespace, "tracked_scores.json"));
            for (class_3298 resource : list) {
                profiler.method_15396(resource.method_14480());
                try {
                    BufferedReader reader = resource.method_43039();
                    profiler.method_15396("parse");
                    JsonObject json = class_3518.method_15255((Reader)reader);
                    JsonArray array = class_3518.method_15261((JsonObject)json, (String)"objectives");
                    for (JsonElement jsonElement : array) {
                        String obj = class_3518.method_15287((JsonElement)jsonElement, (String)"objectives[]").trim();
                        if (objectives.contains(obj)) continue;
                        objectives.add(obj);
                    }
                    profiler.method_15405("register");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        profiler.method_16066();
        return objectives;
    }

    protected void apply(List<String> object, class_3300 resourceManager, class_3695 profiler) {
        MinecraftServer server;
        this.tracked.clear();
        this.tracked.addAll(object);
        if (!this.tracked.isEmpty()) {
            Palladium.LOGGER.info("Registered " + this.tracked.size() + " objectives to be tracked");
        }
        if ((server = Platform.getCurrentServer()) != null) {
            for (String tracked : this.tracked) {
                class_2995 scoreboard = server.method_3845();
                class_266 objective = scoreboard.method_1170(tracked);
                if (objective == null) continue;
                scoreboard.method_12939(objective);
            }
        }
    }

    public List<String> getTracked() {
        return this.tracked;
    }

    public boolean isTracked(String objective) {
        return this.tracked.contains(objective.trim());
    }
}

