/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.accessory.OverlayAccessory;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.ModelLayerLocationUtil;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class HumanoidModelOverlayAccessory
extends OverlayAccessory {
    private final Supplier<Object> modelLayer;
    private final Supplier<Object> modelLayerSlim;
    private Object model;
    private Object modelSlim;

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, TextureReference texture, TextureReference textureSlim) {
        super(texture, textureSlim);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, TextureReference texture, TextureReference textureSlim) {
        super(texture, textureSlim);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, TextureReference texture) {
        super(texture);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, TextureReference texture) {
        super(texture);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, class_2960 texture, class_2960 textureSlim) {
        super(texture, textureSlim);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, class_2960 texture, class_2960 textureSlim) {
        super(texture, textureSlim);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, class_2960 texture) {
        super(texture);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, class_2960 texture) {
        super(texture);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, String texture, String textureSlim) {
        super(texture, textureSlim);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, String texture, String textureSlim) {
        super(texture, textureSlim);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, String texture) {
        super(texture);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, String texture) {
        super(texture);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onReload(class_5599 entityModelSet) {
        class_5601 loc1;
        Object loc = this.modelLayer.get();
        Object locSlim = this.modelLayerSlim.get();
        if (loc instanceof class_5601) {
            loc1 = (class_5601)loc;
            this.model = new class_572(entityModelSet.method_32072(loc1));
        }
        if (locSlim instanceof class_5601) {
            loc1 = (class_5601)locSlim;
            this.modelSlim = new class_572(entityModelSet.method_32072(loc1));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_3883<class_742, class_591<class_742>> renderLayerParent, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Object object = this.getModel(player);
        if (object instanceof class_572) {
            class_572 model = (class_572)object;
            ((class_591)renderLayerParent.method_4038()).method_2818(model);
            this.setVisibility(model, player, slot);
            class_2960 texture = (PlayerUtil.hasSmallArms((class_1657)player) ? this.textureSlim : this.texture).getTexture(DataContext.forEntity((class_1297)player));
            class_1921 renderType = this.getRenderType(player, texture, (class_3879)renderLayerParent.method_4038());
            if (renderType != null) {
                class_4588 buffer = bufferSource.getBuffer(this.glowing ? class_1921.method_23026((class_2960)texture) : renderType);
                model.method_2828(poseStack, buffer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderArm(class_1306 arm, class_742 player, class_1007 playerRenderer, class_630 armPart, class_630 armWearPart, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        Object object = this.getModel(player);
        if (object instanceof class_572) {
            class_572 model = (class_572)object;
            class_2960 texture = (PlayerUtil.hasSmallArms((class_1657)player) ? this.textureSlim : this.texture).getTexture(DataContext.forEntity((class_1297)player));
            class_4588 buffer = bufferSource.getBuffer(this.glowing ? class_1921.method_23026((class_2960)texture) : Objects.requireNonNull(this.getRenderType(player, texture, (class_3879)playerRenderer.method_4038())));
            model.field_3401.method_17138(armPart);
            model.field_3401.field_3665 = true;
            model.field_3401.method_22698(poseStack, buffer, packedLight, class_4608.field_21444);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public Object getModel(class_742 player) {
        return PlayerUtil.hasSmallArms((class_1657)player) ? this.modelSlim : this.model;
    }

    public static class Serializer
    implements AccessoryParser.TypeSerializer {
        @Override
        public DefaultAccessory parse(JsonObject json) {
            SkinTypedValue<TextureReference> texture = SkinTypedValue.fromJSON(json.get("texture"), j -> TextureReference.parse(j.getAsString()));
            SkinTypedValue<ModelLayerLocationUtil> modelLayer = SkinTypedValue.fromJSON(json.get("model_layer"), j -> GsonUtil.convertToModelLayerLocationUtil(j, "model_layer"));
            HumanoidModelOverlayAccessory accessory = new HumanoidModelOverlayAccessory(modelLayer::getNormal, modelLayer::getSlim, texture.getNormal(), texture.getSlim());
            if (class_3518.method_15258((JsonObject)json, (String)"glowing", (boolean)false)) {
                accessory.glowing();
            }
            if (class_3518.method_15258((JsonObject)json, (String)"only_render_for_slot", (boolean)false)) {
                accessory.onlyRenderSlot();
            }
            if (class_3518.method_15258((JsonObject)json, (String)"hand_visibility_fix", (boolean)false)) {
                accessory.handVisibilityFix();
            }
            return accessory;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Humanoid Model Layer");
            builder.setDescription("Renders a humanoid model layer on the player");
            builder.addProperty("texture", TextureReference.class).description("Texture for the accessory. Can be skin-typed by specifying 'normal' and 'slim' in a json object.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/accessory/test.png"));
            builder.addProperty("model_layer", ModelLayerLocationUtil.class).description("Model layer for the accessory. Can be skin-typed by specifying 'normal' and 'slim' in a json object.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/accessory/test.png"));
            builder.addProperty("glowing", Boolean.class).description("Makes the overlay glow").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("only_render_for_slot", Boolean.class).description("If set to true, the texture will only render for the specified slot of the accessory. Example: The texture has a full player skin and the slot is set to 'head', only the head part of it will render.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("hand_visibility_fix", Boolean.class).description("If 'only_render_for_slot' is set to true while the slot is for a hand but you want to have the accessory on the arm, set this to true.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            AccessoryParser.addSlotDocumentation(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("humanoid_model_layer");
        }
    }
}

