/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class RenderLayerAccessory
extends DefaultAccessory {
    public final class_2960 renderLayerId;
    private Object renderLayer;
    private boolean disableRendering = false;

    public RenderLayerAccessory(class_2960 renderLayerId) {
        this.renderLayerId = renderLayerId;
    }

    public RenderLayerAccessory disableRendering() {
        this.disableRendering = true;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onReload(class_5599 entityModelSet) {
        this.renderLayer = PackRenderLayerManager.getInstance().getLayer(this.renderLayerId);
        if (this.renderLayer == null) {
            AddonPackLog.warning("Unknown render layer used in accessory: " + String.valueOf(this.renderLayerId), new Object[0]);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_3883<class_742, class_591<class_742>> renderLayerParent, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Object object;
        if (!this.disableRendering && (object = this.renderLayer) instanceof IPackRenderLayer) {
            IPackRenderLayer layer = (IPackRenderLayer)object;
            class_583 entityModel = renderLayerParent.method_4038();
            layer.render(DataContext.forEntity((class_1297)player), poseStack, bufferSource, (class_583<class_1297>)entityModel, packedLightIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderArm(class_1306 arm, class_742 player, class_1007 playerRenderer, class_630 armPart, class_630 armWearPart, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        Object object;
        if (!this.disableRendering && (object = this.renderLayer) instanceof IPackRenderLayer) {
            IPackRenderLayer layer = (IPackRenderLayer)object;
            layer.renderArm(DataContext.forEntity((class_1297)player), arm, playerRenderer, poseStack, bufferSource, packedLight);
        }
    }

    public static class Serializer
    implements AccessoryParser.TypeSerializer {
        @Override
        public DefaultAccessory parse(JsonObject json) {
            RenderLayerAccessory accessory = new RenderLayerAccessory(GsonUtil.getAsResourceLocation(json, "render_layer"));
            if (class_3518.method_15258((JsonObject)json, (String)"disable_rendering", (boolean)false)) {
                accessory.disableRendering();
            }
            return accessory;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Render Layer");
            builder.setDescription("Let's you use a render layer as an accessory");
            builder.addProperty("render_layer", class_2960.class).description("ID of the render layer that's being used").required().exampleJson((JsonElement)new JsonPrimitive("namespace:example_layer"));
            builder.addProperty("disable_rendering", Boolean.class).description("Disables the rendering of the accessory, in case you want to hook it up to a render_layer_from_accessory ability").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            AccessoryParser.addSlotDocumentation(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("render_layer");
        }
    }
}

