/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack;

import architectury_inject_palladium_common_5b1c37597e5e47f79a3a603f6551a148_32046caadf39536d5b7a20149548d254edb99a9c1da82147aa82510750d79604palladium4311201devjar.PlatformMethods;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3518;
import net.minecraft.class_3902;
import net.minecraft.class_442;
import net.minecraft.class_5352;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.PackData;
import net.threetag.palladium.addonpack.fabric.AddonPackManagerImpl;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.log.AddonPackLogEntry;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.addonpack.parser.AccessorySlotParser;
import net.threetag.palladium.addonpack.parser.ArmorMaterialParser;
import net.threetag.palladium.addonpack.parser.BlockParser;
import net.threetag.palladium.addonpack.parser.CreativeModeTabParser;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.addonpack.parser.ParticleTypeParser;
import net.threetag.palladium.addonpack.parser.PoiTypeParser;
import net.threetag.palladium.addonpack.parser.SuitSetParser;
import net.threetag.palladium.addonpack.parser.ToolTierParser;
import net.threetag.palladium.addonpack.parser.VillagerProfessionParser;
import net.threetag.palladium.addonpack.parser.VillagerTradeParser;
import net.threetag.palladium.client.screen.AddonPackLogScreen;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.ScreenEvents;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.NotNull;

public class AddonPackManager {
    private static AddonPackManager INSTANCE;
    public static class_3264 PACK_TYPE;
    public static boolean IGNORE_INJECT;
    public static ItemParser ITEM_PARSER;
    private static CompletableFuture<AddonPackManager> loaderFuture;
    private final Map<String, PackData> packs = new HashMap<String, PackData>();
    private final class_3304 resourceManager;
    private final class_3285 folderPackFinder;
    private final class_3283 packList;
    private QueueableExecutor mainThreadExecutor;

    public static AddonPackManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AddonPackManager();
        }
        return INSTANCE;
    }

    public static void startLoading() {
        Palladium.LOGGER.info("Starting addonpack initialisation...");
        loaderFuture = AddonPackManager.getInstance().beginLoading(class_156.method_18349());
    }

    public static void waitForLoading() {
        AddonPackManager.getInstance().waitForLoading(loaderFuture);
        loaderFuture = null;
    }

    private AddonPackManager() {
        class_3285[] class_3285Array;
        IGNORE_INJECT = true;
        this.resourceManager = new class_3304(AddonPackManager.getPackType());
        this.folderPackFinder = new class_3279(this.getLocation(), AddonPackManager.getPackType(), class_5352.field_25347);
        class_3285 modSource = AddonPackManager.getModRepositorySource();
        if (modSource == null) {
            class_3285[] class_3285Array2 = new class_3285[1];
            class_3285Array = class_3285Array2;
            class_3285Array2[0] = this.folderPackFinder;
        } else {
            class_3285[] class_3285Array3 = new class_3285[2];
            class_3285Array3[0] = this.folderPackFinder;
            class_3285Array = class_3285Array3;
            class_3285Array3[1] = modSource;
        }
        class_3285[] sources = class_3285Array;
        this.packList = new class_3283(sources);
        IGNORE_INJECT = false;
        this.resourceManager.method_14477((class_3302)new CreativeModeTabParser());
        this.resourceManager.method_14477((class_3302)new ArmorMaterialParser());
        this.resourceManager.method_14477((class_3302)new ToolTierParser());
        this.resourceManager.method_14477((class_3302)new BlockParser());
        ITEM_PARSER = new ItemParser();
        this.resourceManager.method_14477((class_3302)ITEM_PARSER);
        this.resourceManager.method_14477((class_3302)new SuitSetParser());
        this.resourceManager.method_14477((class_3302)new ParticleTypeParser());
        this.resourceManager.method_14477((class_3302)new PoiTypeParser());
        this.resourceManager.method_14477((class_3302)new VillagerProfessionParser());
        this.resourceManager.method_14477((class_3302)new VillagerTradeParser());
        this.resourceManager.method_14477((class_3302)new AccessorySlotParser());
        this.resourceManager.method_14477((class_3302)new AccessoryParser());
    }

    public Path getLocation() {
        Path folder = Platform.getFolder().resolve("addonpacks");
        File file = folder.toFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Could not create addonpacks directory! Please create the directory yourself, or make sure the name is not taken by a file and you have permission to create directories.");
        }
        return folder;
    }

    public class_3285 getWrappedPackFinder() {
        return AddonPackManager.getWrappedPackFinder(this.folderPackFinder);
    }

    public Collection<PackData> getPacks() {
        return this.packs.values();
    }

    public PackData getPackData(String id) {
        return this.packs.get(id);
    }

    public class_3283 getPackList() {
        return this.packList;
    }

    public static class_3285 getWrappedPackFinder(class_3285 folderPackFinder) {
        return infoConsumer -> folderPackFinder.method_14453(pack -> {
            pack.field_14272 = "addonpack:" + pack.method_14463();
            pack.field_14271 = true;
            infoConsumer.accept(pack);
        });
    }

    public static class_3264 getPackType() {
        class_3264 client = class_3264.field_14188;
        return PACK_TYPE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_3285 getModRepositorySource() {
        return AddonPackManagerImpl.getModRepositorySource();
    }

    public CompletableFuture<AddonPackManager> beginLoading(Executor backgroundExecutor) {
        this.packList.method_14445();
        this.packList.method_14447(this.packList.method_29206());
        this.packs.clear();
        this.packList.method_14441().forEach(pack -> {
            try {
                InputStream stream = (InputStream)pack.method_14458().method_14410(new String[]{"pack.mcmeta"}).get();
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                JsonObject jsonobject = class_3518.method_15255((Reader)bufferedreader);
                PackData packData = PackData.fromJSON(jsonobject);
                if (packData == null) {
                    bufferedreader.close();
                    stream.close();
                    Palladium.LOGGER.info("Skipping " + pack.method_14463() + " as it's not been marked as an addonpack");
                }
                if (this.packs.containsKey(packData.getId())) {
                    bufferedreader.close();
                    stream.close();
                    throw new RuntimeException("Duplicate addonpack: " + packData.getId());
                }
                this.packs.put(packData.getId(), packData);
                bufferedreader.close();
                stream.close();
            }
            catch (Exception e) {
                AddonPackLog.error(e.getLocalizedMessage(), new Object[0]);
            }
        });
        HashMap<PackData, List> dependencyConflicts = new HashMap<PackData, List>();
        for (PackData pack2 : this.packs.values()) {
            for (PackData.Dependency dependency : pack2.getDependenciesFor(PlatformMethods.getCurrentTarget())) {
                if (dependency.isValid()) continue;
                dependencyConflicts.computeIfAbsent(pack2, p -> new ArrayList()).add(dependency);
            }
        }
        if (!dependencyConflicts.isEmpty()) {
            ArrayList<CallSite> test = new ArrayList<CallSite>();
            for (Map.Entry entry : dependencyConflicts.entrySet()) {
                for (PackData.Dependency dependency : (List)entry.getValue()) {
                    test.add((CallSite)((Object)("Pack " + ((PackData)entry.getKey()).getId() + " requires " + dependency.getId() + " " + Arrays.toString(dependency.getVersionRequirements().toArray()))));
                }
            }
            if (Platform.isServer()) {
                throw new RuntimeException(Arrays.toString(test.toArray()));
            }
            ScreenEvents.OPENING.register((currentScreen, newScreen) -> {
                if (newScreen.get() instanceof class_442) {
                    newScreen.set(new AddonPackLogScreen(dependencyConflicts.keySet().stream().map(packData -> {
                        StringBuilder s = new StringBuilder("Addon Pack '" + packData.getId() + "' requires ");
                        for (PackData.Dependency dependency : (List)dependencyConflicts.get(packData)) {
                            s.append(dependency.getId()).append(" ").append(Arrays.toString(dependency.getVersionRequirements().toArray())).append("; ");
                        }
                        s = new StringBuilder(s.substring(0, s.length() - 2));
                        return new AddonPackLogEntry(AddonPackLogEntry.Type.ERROR, s.toString());
                    }).collect(Collectors.toList()), null));
                }
                return EventResult.pass();
            });
        }
        this.mainThreadExecutor = new QueueableExecutor();
        return ((CompletableFuture)((CompletableFuture)this.resourceManager.method_18232(backgroundExecutor, (Executor)this.mainThreadExecutor, CompletableFuture.completedFuture(class_3902.field_17274), this.packList.method_29211()).method_18364().whenComplete((unit, throwable) -> {
            if (throwable != null) {
                this.resourceManager.close();
                AddonPackLog.error(throwable.getMessage(), new Object[0]);
            }
        })).thenRun(this.mainThreadExecutor::finish)).thenApply(unit -> this);
    }

    private void finish() {
        Palladium.LOGGER.info("Finished addonpack initialisation!");
    }

    public void waitForLoading(CompletableFuture<AddonPackManager> loaderFuture) {
        try {
            while (!loaderFuture.isDone()) {
                this.mainThreadExecutor.runQueue();
                this.mainThreadExecutor.waitForTasks();
            }
            this.mainThreadExecutor.runQueue();
            loaderFuture.get().finish();
        }
        catch (InterruptedException e) {
            Palladium.LOGGER.error("Addonpack loader future interrupted!");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new class_148(class_128.method_560((Throwable)cause, (String)"Error loading addonpacks"));
        }
    }

    static {
        IGNORE_INJECT = false;
    }

    public static class QueueableExecutor
    implements Executor {
        private final Thread thread = Thread.currentThread();
        private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
        private final Semaphore sem = new Semaphore(1);

        public boolean isSameThread() {
            return Thread.currentThread() == this.thread;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (!this.isSameThread()) {
                this.queue.add(command);
                this.sem.release();
            } else {
                command.run();
            }
        }

        public void runQueue() {
            if (!this.isSameThread()) {
                throw new IllegalStateException("This method must be called in the main thread.");
            }
            while (this.queue.size() > 0) {
                Runnable run = this.queue.poll();
                if (run == null) continue;
                run.run();
            }
        }

        public void finish() {
            this.sem.release();
        }

        public void waitForTasks() throws InterruptedException {
            this.sem.acquire();
        }
    }
}

