/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil;
import net.threetag.palladium.item.AddonItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.RegistrySynonymsHandler;
import net.threetag.palladium.util.Utils;
import net.threetag.palladiumcore.registry.CreativeModeTabRegistry;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
extends AddonBuilder<class_1792> {
    private final JsonObject json;
    private class_2960 typeSerializerId = null;
    private Integer maxStackSize = null;
    private Integer maxDamage = null;
    private Boolean isFireResistant = null;
    private final List<ItemParser.PlacedTabPlacement> creativeModeTabs = new ArrayList<ItemParser.PlacedTabPlacement>();
    private class_1814 rarity = null;
    private List<class_2561> tooltipLines = null;
    private Multimap<class_2960, class_1322> attributeModifiersAllSlots;
    private Map<PlayerSlot, Multimap<class_2960, class_1322>> attributeModifiers;
    private class_4174 foodProperties = null;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private boolean registerCurioTrinket = false;
    private boolean shouldRenderModel = true;

    public ItemBuilder(class_2960 id, JsonObject json) {
        super(id);
        this.json = json;
    }

    @Override
    protected class_1792 create() {
        ItemParser.ItemTypeSerializer serializer;
        class_1792.class_1793 properties = new class_1792.class_1793();
        if (this.maxDamage != null && this.maxDamage != 0) {
            Utils.ifNotNull(this.maxDamage, arg_0 -> ((class_1792.class_1793)properties).method_7895(arg_0));
        }
        if (this.maxStackSize != null && this.maxStackSize != 64) {
            Utils.ifNotNull(this.maxStackSize, arg_0 -> ((class_1792.class_1793)properties).method_7889(arg_0));
        }
        Utils.ifNotNull(this.rarity, arg_0 -> ((class_1792.class_1793)properties).method_7894(arg_0));
        Utils.ifNotNull(this.rarity, arg_0 -> ((class_1792.class_1793)properties).method_7894(arg_0));
        Utils.ifTrue(this.isFireResistant, () -> ((class_1792.class_1793)properties).method_24359());
        properties.method_19265(this.foodProperties);
        if (this.typeSerializerId == null) {
            this.typeSerializerId = ItemParser.FALLBACK_SERIALIZER;
        }
        if ((serializer = ItemParser.getTypeSerializer(this.typeSerializerId)) == null) {
            AddonPackLog.warning("Unknown item type '" + String.valueOf(this.typeSerializerId) + "', falling back to '" + String.valueOf(ItemParser.FALLBACK_SERIALIZER) + "'", new Object[0]);
        }
        IAddonItem item = serializer != null ? serializer.parse(this.json, properties) : new AddonItem(properties);
        Utils.ifNotNull(this.tooltipLines, item::setTooltip);
        if (this.attributeModifiers != null) {
            for (PlayerSlot slot : this.attributeModifiers.keySet()) {
                for (class_2960 attributeId : this.attributeModifiers.get(slot).keySet()) {
                    class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(RegistrySynonymsHandler.getReplacement(class_7923.field_41190, attributeId));
                    if (attribute != null) {
                        for (class_1322 attributeModifier : this.attributeModifiers.get(slot).get((Object)attributeId)) {
                            item.getAttributeContainer().add(slot, attribute, attributeModifier);
                        }
                        continue;
                    }
                    throw new JsonParseException("Unknown attribute '" + String.valueOf(attributeId) + "'");
                }
            }
        }
        if (this.attributeModifiersAllSlots != null) {
            for (class_2960 attributeId : this.attributeModifiersAllSlots.keySet()) {
                class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(RegistrySynonymsHandler.getReplacement(class_7923.field_41190, attributeId));
                if (attribute != null) {
                    for (class_1322 attributeModifier : this.attributeModifiersAllSlots.get((Object)attributeId)) {
                        item.getAttributeContainer().addForAllSlots(attribute, attributeModifier);
                    }
                    continue;
                }
                throw new JsonParseException("Unknown attribute '" + String.valueOf(attributeId) + "'");
            }
        }
        item.setRenderLayerContainer(this.renderLayerContainer);
        if (this.registerCurioTrinket) {
            CuriosTrinketsUtil.getInstance().registerCurioTrinket((class_1792)item, new CurioTrinket(item));
        }
        for (ItemParser.PlacedTabPlacement creativeModeTab : this.creativeModeTabs) {
            class_5321 tabKey = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)creativeModeTab.getTab());
            CreativeModeTabRegistry.addToTab((class_5321)tabKey, entries -> creativeModeTab.addToTab((CreativeModeTabRegistry.ItemGroupEntries)entries, (class_1792)item));
        }
        item.setShouldRenderModel(this.shouldRenderModel);
        return (class_1792)item;
    }

    public ItemBuilder type(class_2960 serializerId) {
        this.typeSerializerId = serializerId;
        return this;
    }

    public ItemBuilder maxStackSize(int stackSize) {
        this.maxStackSize = stackSize;
        return this;
    }

    public ItemBuilder maxDamage(int maxDamage) {
        this.maxDamage = maxDamage;
        return this;
    }

    public ItemBuilder creativeModeTab(ItemParser.PlacedTabPlacement tabPlacement) {
        this.creativeModeTabs.add(tabPlacement);
        return this;
    }

    public ItemBuilder rarity(class_1814 rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemBuilder fireResistant(boolean isFireResistant) {
        this.isFireResistant = isFireResistant;
        return this;
    }

    public ItemBuilder tooltipLines(List<class_2561> tooltipLines) {
        this.tooltipLines = tooltipLines;
        return this;
    }

    public ItemBuilder addAttributeModifier(@Nullable PlayerSlot slot, class_2960 attributeId, class_1322 modifier) {
        this.registerCurioTrinket = true;
        if (slot == null) {
            if (this.attributeModifiersAllSlots == null) {
                this.attributeModifiersAllSlots = ArrayListMultimap.create();
            }
            this.attributeModifiersAllSlots.put((Object)attributeId, (Object)modifier);
            return this;
        }
        if (this.attributeModifiers == null) {
            this.attributeModifiers = new HashMap<PlayerSlot, Multimap<class_2960, class_1322>>();
        }
        this.attributeModifiers.computeIfAbsent(slot, equipmentSlot -> ArrayListMultimap.create()).put((Object)attributeId, (Object)modifier);
        return this;
    }

    public ItemBuilder setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
        return this;
    }

    public ItemBuilder food(class_4174 foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    public ItemBuilder shouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
        return this;
    }

    public static class CurioTrinket
    implements net.threetag.palladium.compat.curiostinkets.CurioTrinket {
        private final IAddonItem item;

        public CurioTrinket(IAddonItem item) {
            this.item = item;
        }

        @Override
        public Multimap<class_1320, class_1322> getModifiers(PlayerSlot slot, class_1309 entity) {
            return this.item.getAttributeContainer().get(slot, (Multimap<class_1320, class_1322>)ArrayListMultimap.create());
        }
    }
}

