/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.fabric;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_4239;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.PalladiumMixinPlugin;
import net.threetag.palladium.addonpack.AddonPackManager;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonPackManagerImpl {
    public static class_3285 getModRepositorySource() {
        return new ModPackSource(Objects.requireNonNull(AddonPackManager.getPackType()));
    }

    public static class ModPackSource
    implements class_3285 {
        private final class_3264 type;

        public ModPackSource(class_3264 type) {
            this.type = type;
        }

        public void method_14453(Consumer<class_3288> onLoad) {
            for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
                ModNioResourcePack pack;
                if (container.getMetadata().getType().equals("builtin") || (pack = ModNioResourcePack.create((String)container.getMetadata().getId(), (ModContainer)container, null, (class_3264)this.type, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED)) == null || Objects.equals(pack.method_14409(), "minecraft")) continue;
                class_3288 resourcePackProfile = class_3288.method_45275((String)("mod:" + pack.method_14409()), (class_2561)class_2561.method_30163((String)pack.getFabricModMetadata().getName()), (boolean)false, arg_0 -> ModPackSource.lambda$loadPacks$0(container, (net.fabricmc.fabric.api.resource.ModResourcePack)pack, arg_0), (class_3264)this.type, (class_3288.class_3289)class_3288.class_3289.field_14281, (class_5352)ModResourcePackCreator.RESOURCE_PACK_SOURCE);
                onLoad.accept(resourcePackProfile);
            }
            if (!PalladiumMixinPlugin.HAS_QUILT) {
                ResourceManagerHelperImpl.registerBuiltinResourcePacks((class_3264)this.type, onLoad);
            }
        }

        private static /* synthetic */ class_3262 lambda$loadPacks$0(ModContainer container, net.fabricmc.fabric.api.resource.ModResourcePack pack, String factory) {
            return new ModResourcePack(container, pack.method_14409(), true, container.getRootPath());
        }
    }

    public static class ModResourcePack
    extends class_3255 {
        private final ModContainer modContainer;
        private final Path source;

        public ModResourcePack(ModContainer modContainer, String packId, boolean isBuiltin, Path source) {
            super(packId, isBuiltin);
            this.modContainer = modContainer;
            this.source = source;
        }

        public Path getSource() {
            return this.source;
        }

        protected Path resolve(String ... paths) {
            String fileName = String.join((CharSequence)"/", paths);
            return this.modContainer.findPath(fileName).orElse(null);
        }

        @Nullable
        public class_7367<InputStream> method_14410(String ... paths) {
            String fileName = String.join((CharSequence)"/", paths);
            Path path = this.resolve(paths);
            if ("pack.mcmeta".equals(fileName) && (path == null || !Files.exists(path, new LinkOption[0]))) {
                String id = this.modContainer.getMetadata().getId();
                String version = this.modContainer.getMetadata().getVersion().getFriendlyString();
                String description = this.modContainer.getMetadata().getDescription();
                String pack = String.format("{\"pack\":{\"id\": \"%s\", \"version\": \"%s\", \"description\":\"%s\"}}", id, version, description);
                return () -> IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return class_7367.create((Path)path);
        }

        public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 resourceOutput) {
            class_4239.method_46346((String)path).get().ifLeft(parts -> class_3259.method_45183((String)namespace, (Path)this.resolve(type.method_14413(), namespace).toAbsolutePath(), (List)parts, (class_3262.class_7664)resourceOutput)).ifRight(dataResult -> Palladium.LOGGER.error("Invalid path {}: {}", (Object)path, (Object)dataResult.message()));
        }

        public Set<String> method_14406(class_3264 type) {
            return this.getNamespacesFromDisk(type);
        }

        @NotNull
        private Set<String> getNamespacesFromDisk(class_3264 type) {
            Set<String> set;
            block9: {
                Path root = this.resolve(type.method_14413());
                Stream<Path> walker = Files.walk(root, 1, new FileVisitOption[0]);
                try {
                    set = walker.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(root::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                    if (walker == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (walker != null) {
                            try {
                                walker.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (type == class_3264.field_14190) {
                            return this.method_14406(class_3264.field_14188);
                        }
                        return Collections.emptySet();
                    }
                }
                walker.close();
            }
            return set;
        }

        public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
            return this.method_14410(ModResourcePack.getPathFromLocation(location.method_12832().startsWith("lang/") ? class_3264.field_14188 : type, location));
        }

        private static String[] getPathFromLocation(class_3264 type, class_2960 location) {
            String[] parts = location.method_12832().split("/");
            String[] result = new String[parts.length + 2];
            result[0] = type.method_14413();
            result[1] = location.method_12836();
            System.arraycopy(parts, 0, result, 2, parts.length);
            return result;
        }

        public void close() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "%s: %s (%s)", ((Object)((Object)this)).getClass().getName(), this.method_14409(), this.getSource());
        }
    }
}

