/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.log;

import java.util.ArrayList;
import java.util.List;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLogEntry;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class AddonPackLog {
    private static final List<AddonPackLogEntry> ENTRIES = new ArrayList<AddonPackLogEntry>();

    public static List<AddonPackLogEntry> getEntries() {
        return ENTRIES;
    }

    public static void info(String message, Object ... params) {
        Palladium.LOGGER.info(message, params);
        FormattedMessage msg = new FormattedMessage(message, params);
        ENTRIES.add(new AddonPackLogEntry(AddonPackLogEntry.Type.INFO, (Message)msg));
    }

    public static void error(String message, Object ... params) {
        Palladium.LOGGER.error(message, params);
        FormattedMessage msg = new FormattedMessage(message, params);
        ENTRIES.add(new AddonPackLogEntry(AddonPackLogEntry.Type.ERROR, (Message)msg));
    }

    public static void error(Exception exception, String message, Object ... params) {
        Palladium.LOGGER.error(message, params);
        FormattedMessage msg = new FormattedMessage(message + "\n" + exception.getMessage(), params);
        ENTRIES.add(new AddonPackLogEntry(AddonPackLogEntry.Type.ERROR, (Message)msg, exception.getStackTrace()));
    }

    public static void warning(String message, Object ... params) {
        Palladium.LOGGER.warn(message, params);
        FormattedMessage msg = new FormattedMessage(message, params);
        ENTRIES.add(new AddonPackLogEntry(AddonPackLogEntry.Type.WARNING, (Message)msg));
    }

    public static void warning(Exception exception, String message, Object ... params) {
        Palladium.LOGGER.warn(message, params);
        FormattedMessage msg = new FormattedMessage(message + "\n" + exception.getMessage(), params);
        ENTRIES.add(new AddonPackLogEntry(AddonPackLogEntry.Type.WARNING, (Message)msg, exception.getStackTrace()));
    }
}

