/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.fabric.AddonParserImpl;

public abstract class AddonParser<T>
extends class_4309 {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final class_5321<? extends class_2378<T>> resourceKey;

    public AddonParser(Gson gson, String string, class_5321<? extends class_2378<T>> resourceKey) {
        super(gson, string);
        this.resourceKey = resourceKey;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.injectJsons(object);
        AtomicInteger i = new AtomicInteger();
        HashMap addonBuilders = new HashMap();
        HashMap loadingOrders = new HashMap();
        object.forEach((id, jsonElement) -> {
            try {
                if (id.method_12832().equalsIgnoreCase("_loading_order")) {
                    loadingOrders.put(id.method_12836(), this.parseLoadingOrder((JsonElement)jsonElement));
                } else {
                    addonBuilders.put(id, this.parse((class_2960)id, (JsonElement)jsonElement));
                    i.getAndIncrement();
                }
            }
            catch (Exception e) {
                class_128 crashReport = class_128.method_560((Throwable)e, (String)("Error while parsing addonpack " + this.resourceKey.method_29177().method_12832() + " '" + String.valueOf(id) + "'"));
                class_129 reportCategory = crashReport.method_556("Addon " + this.resourceKey.method_29177().method_12832(), 1);
                reportCategory.method_578("Resource name", id);
                throw new class_148(crashReport);
            }
        });
        TreeMap sorted = new TreeMap((id1, id2) -> {
            if (id1.method_12836().equals(id2.method_12836())) {
                List order = (List)loadingOrders.get(id1.method_12836());
                if (order == null) {
                    return id1.method_12833(id2);
                }
                if (order.contains(id1.method_12832()) && !order.contains(id2.method_12832())) {
                    return -1;
                }
                if (!order.contains(id1.method_12832()) && order.contains(id2.method_12832())) {
                    return 1;
                }
                if (!order.contains(id1.method_12832()) && !order.contains(id2.method_12832())) {
                    return id1.method_12833(id2);
                }
                return order.indexOf(id1.method_12832()) - order.indexOf(id2.method_12832());
            }
            return id1.method_12833(id2);
        });
        sorted.putAll(addonBuilders);
        for (AddonBuilder addonBuilder : sorted.values()) {
            AddonParser.register(this.resourceKey, addonBuilder);
            this.postRegister(addonBuilder);
        }
        AddonPackLog.info("Registered " + i.get() + " addonpack " + this.resourceKey.method_29177().method_12832(), new Object[0]);
    }

    public List<String> parseLoadingOrder(JsonElement jsonElement) {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        LinkedList<String> list = new LinkedList<String>();
        for (JsonElement element : jsonArray) {
            list.add(element.getAsString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void register(class_5321<? extends class_2378<T>> key, AddonBuilder<T> builder) {
        void var1_1;
        AddonParserImpl.register(key, var1_1);
    }

    public void postRegister(AddonBuilder<T> addonBuilder) {
    }

    public void injectJsons(Map<class_2960, JsonElement> map) {
    }

    public abstract AddonBuilder<T> parse(class_2960 var1, JsonElement var2);
}

