/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.item.SimpleArmorMaterial;

public class ArmorMaterialParser
extends class_4309 {
    private static final Map<class_2960, class_1741> ARMOR_MATERIALS = new HashMap<class_2960, class_1741>();

    public ArmorMaterialParser() {
        super(AddonParser.GSON, "armor_materials");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ArmorMaterialParser.registerArmorMaterial(new class_2960("leather"), (class_1741)class_1740.field_7897);
        ArmorMaterialParser.registerArmorMaterial(new class_2960("chainmail"), (class_1741)class_1740.field_7887);
        ArmorMaterialParser.registerArmorMaterial(new class_2960("iron"), (class_1741)class_1740.field_7892);
        ArmorMaterialParser.registerArmorMaterial(new class_2960("gold"), (class_1741)class_1740.field_7895);
        ArmorMaterialParser.registerArmorMaterial(new class_2960("diamond"), (class_1741)class_1740.field_7889);
        ArmorMaterialParser.registerArmorMaterial(new class_2960("turtle"), (class_1741)class_1740.field_7890);
        ArmorMaterialParser.registerArmorMaterial(new class_2960("netherite"), (class_1741)class_1740.field_21977);
        AtomicInteger i = new AtomicInteger();
        object.forEach((id, jsonElement) -> {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"$");
                SimpleArmorMaterial armorMaterial = ArmorMaterialParser.parse(id, json);
                ArmorMaterialParser.registerArmorMaterial(id, (class_1741)armorMaterial);
                i.getAndIncrement();
            }
            catch (Exception e) {
                class_128 crashReport = class_128.method_560((Throwable)e, (String)("Error while parsing addonpack armor material  '" + String.valueOf(id) + "'"));
                class_129 reportCategory = crashReport.method_556("Addon Armor Material", 1);
                reportCategory.method_578("Resource name", id);
                throw new class_148(crashReport);
            }
        });
        AddonPackLog.info("Registered " + i.get() + " addonpack armor materials", new Object[0]);
    }

    public static void registerArmorMaterial(class_2960 id, class_1741 armorMaterial) {
        ARMOR_MATERIALS.put(id, armorMaterial);
    }

    public static class_1741 getArmorMaterial(class_2960 id) {
        return ARMOR_MATERIALS.get(id);
    }

    public static Set<class_2960> getIds() {
        return ARMOR_MATERIALS.keySet();
    }

    public static SimpleArmorMaterial parse(class_2960 id, JsonObject json) {
        return new SimpleArmorMaterial(id.method_12832(), GsonUtil.getAsIntMin(json, "durability_multiplier", 0), ArmorMaterialParser.parseArmorProtectionMap(json.get("slot_protections")), GsonUtil.getAsIntMin(json, "enchantment_value", 0), () -> (class_3414)class_7923.field_41172.method_10223(GsonUtil.getAsResourceLocation(json, "equip_sound")), class_3518.method_15277((JsonObject)json, (String)"toughness", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"knockback_resistance", (float)0.0f), () -> json.has("repair_ingredient") ? class_1856.method_52177((JsonElement)json.get("repair_ingredient")) : class_1856.field_9017);
    }

    public static EnumMap<class_1738.class_8051, Integer> parseArmorProtectionMap(JsonElement jsonElement) {
        EnumMap<class_1738.class_8051, Integer> map = new EnumMap<class_1738.class_8051, Integer>(class_1738.class_8051.class);
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                class_1738.class_8051 type = class_1738.class_8051.values()[3 - i];
                map.put(type, array.get(i).getAsInt());
            }
        } else if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            for (class_1738.class_8051 type : class_1738.class_8051.values()) {
                if (!class_3518.method_15294((JsonObject)object, (String)type.method_48400())) continue;
                map.put(type, GsonUtil.getAsIntMin(object, type.method_48400(), 0));
            }
        } else {
            throw new JsonParseException("slot_protections must be json array or object");
        }
        return map;
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each armor material goes into a seperate file into the 'addon/[namespace]/armor_materials' folder, which can then be used for custom armor items/suit sets.");
        builder.addProperty("durability_multiplier", Integer.class).description("A value that gets multiplied with 13, 15, 16 or 11 (feet, legs, chest, head) depending on the slot. Used for the durability value of the item.").required().exampleJson((JsonElement)new JsonPrimitive((Number)12));
        JsonObject slotProtections = new JsonObject();
        slotProtections.addProperty(class_1738.class_8051.field_41934.method_48400(), (Number)3);
        slotProtections.addProperty(class_1738.class_8051.field_41935.method_48400(), (Number)8);
        slotProtections.addProperty(class_1738.class_8051.field_41936.method_48400(), (Number)6);
        slotProtections.addProperty(class_1738.class_8051.field_41937.method_48400(), (Number)3);
        builder.addProperty("slot_protections", JsonObject.class).description("Protection values for the armor pieces, determines the defense value of each slot. For reference (Order: feet, legs, chest, head), iron has [2, 5, 6, 2], diamond is in the example.").required().exampleJson((JsonElement)slotProtections);
        builder.addProperty("enchantment_value", Integer.class).description("Determines the enchantibility of the item. For reference: iron has 9, diamond 10, gold 25.").required().exampleJson((JsonElement)new JsonPrimitive((Number)12));
        builder.addProperty("equip_sound", class_2960.class).description("Sound that is played when equipping the item into the slot.").required().exampleJson((JsonElement)new JsonPrimitive(Objects.requireNonNull(class_7923.field_41172.method_10221((Object)class_3417.field_14862)).toString()));
        builder.addProperty("toughness", Float.class).description("Adds additional armor toughness. For reference: diamond has 2.0, netherite has 3.0, rest has 0.").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.5f)));
        builder.addProperty("knockback_resistance", Float.class).description("Adds knockback resistance. For reference: netherite has 0.1, rest has 0.").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.1f)));
        builder.addProperty("repair_ingredient", class_1856.class).description("Ingredient definition for repairing the item in an anvil. Can be defined like in recipes.").fallback(class_1856.field_9017, "empty ingredient").exampleJson(class_1856.method_8106((class_6862)class_3489.field_36269).method_8089());
        return new HTMLBuilder(new class_2960("palladium", "armor_materials"), "Armor Materials").add(HTMLBuilder.heading("Armor Materials")).addDocumentation(builder);
    }
}

