/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarReference;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class EnergyBarTextureVariable
extends AbstractIntegerTextureVariable {
    private final EnergyBarReference reference;

    public EnergyBarTextureVariable(class_2960 powerId, String energyBarName, List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
        this.reference = new EnergyBarReference(powerId, energyBarName);
    }

    @Override
    public int getNumber(DataContext context) {
        class_1309 livingEntity = context.getLivingEntity();
        if (livingEntity != null) {
            EnergyBar bar = this.reference.getEntry(livingEntity);
            if (bar == null) {
                return 0;
            }
            return bar.get();
        }
        return 0;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new EnergyBarTextureVariable(GsonUtil.getAsResourceLocation(json, "power"), class_3518.method_15265((JsonObject)json, (String)"energy_bar"), AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the value of an energy bar. The math operations can be arranged in any order and are fully optional!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Energy Bar");
            builder.addProperty("power", class_2960.class).description("ID of the power the energy bar is in.").required().exampleJson((JsonElement)new JsonPrimitive("example:power_id"));
            builder.addProperty("energy_bar", String.class).description("Name of the energy bar that is being looked for.").required().exampleJson((JsonElement)new JsonPrimitive("energy_bar_name"));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("energy_bar");
        }
    }
}

