/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_266;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;

public class ObjectiveScoreTextureVariable
extends AbstractIntegerTextureVariable {
    private final String objectiveName;

    public ObjectiveScoreTextureVariable(String objectiveName, List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
        this.objectiveName = objectiveName;
    }

    @Override
    public int getNumber(DataContext context) {
        class_266 objective;
        class_1937 level = context.getLevel();
        class_1297 entity = context.getEntity();
        if (level != null && entity != null && (objective = level.method_8428().method_1170(this.objectiveName)) != null && level.method_8428().method_1183(entity.method_5820(), objective)) {
            return level.method_8428().method_1180(entity.method_5820(), objective).method_1126();
        }
        return 0;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new ObjectiveScoreTextureVariable(class_3518.method_15265((JsonObject)json, (String)"objective"), AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the value of a score of an entity in the scoreboard for the given objective. IF YOU USE THIS, MAKE A 'tracked_score.json' AND PUT THE OBJECTIVE NAME IN IT, MORE ON THE WIKI!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Objective Score");
            builder.addProperty("objective", String.class).description("Name of the objective.").required().exampleJson((JsonElement)new JsonPrimitive("objective_name"));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("objective_score");
        }
    }
}

