/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.client.energybeam.EnergyBeamRenderer;
import net.threetag.palladium.client.energybeam.LaserBeamRenderer;
import net.threetag.palladium.client.particleemitter.ParticleEmitter;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class EnergyBeam {
    private final BodyPart anchor;
    private final PerspectiveValue<Vector3f> offset;
    private final EnergyBeamRenderer renderer;
    private final List<Particle> particles;

    public EnergyBeam(BodyPart anchor, PerspectiveValue<Vector3f> offset, EnergyBeamRenderer renderer, List<Particle> particles) {
        this.anchor = anchor;
        this.offset = offset;
        this.renderer = renderer;
        this.particles = particles;
    }

    public class_243 getOriginPosition(class_742 player, float partialTick) {
        return BodyPart.getInWorldPosition(this.anchor, this.offset.get(), player, partialTick);
    }

    public void spawnParticles(class_1937 level, class_243 pos) {
        for (Particle particle : this.particles) {
            particle.spawn(level, pos);
        }
    }

    public void render(class_742 player, class_243 anchor, class_243 target, float lengthMultiplier, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        class_243 origin = this.getOriginPosition(player, partialTick).method_1020(anchor);
        target = target.method_1020(anchor);
        poseStack.method_22903();
        poseStack.method_22904(origin.field_1352, origin.field_1351, origin.field_1350);
        this.renderer.render(player, origin, target, lengthMultiplier, poseStack, bufferSource, packedLightIn, isFirstPerson, partialTick);
        poseStack.method_22909();
    }

    public static EnergyBeam fromJson(JsonObject json) {
        EnergyBeamRenderer.Serializer serializer = EnergyBeamManager.getRenderer(GsonUtil.getAsResourceLocation(json, "type", LaserBeamRenderer.Serializer.ID));
        if (serializer == null) {
            throw new JsonParseException("Unknown energy beam renderer '" + String.valueOf(GsonUtil.getAsResourceLocation(json, "type", LaserBeamRenderer.Serializer.ID)) + "'");
        }
        return new EnergyBeam(BodyPart.fromJson(class_3518.method_15265((JsonObject)json, (String)"body_part")), PerspectiveValue.getFromJson(json, "offset", j -> GsonUtil.convertToVector3f(j, "offset").div(16.0f, -16.0f, 16.0f), new Vector3f()), serializer.fromJson(json), json.has("particles") ? GsonUtil.fromListOrPrimitive(json.get("particles"), jsonElement -> Particle.fromJson(class_3518.method_15295((JsonElement)jsonElement, (String)"particles[].$"))) : Collections.emptyList());
    }

    public record Particle(class_2396<?> particleType, String options, ParticleEmitter emitter) {
        public static Particle fromJson(JsonObject json) {
            class_2960 particleTypeId = GsonUtil.getAsResourceLocation(json, "particle_type");
            if (!class_7923.field_41180.method_10250(particleTypeId)) {
                throw new JsonParseException("Unknown particle type '" + String.valueOf(particleTypeId) + "'");
            }
            class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(particleTypeId);
            String options = class_3518.method_15253((JsonObject)json, (String)"options", (String)"");
            ParticleEmitter emitter = ParticleEmitter.fromJson(json);
            return new Particle(particleType, options, emitter);
        }

        public void spawn(class_1937 level, class_243 pos) {
            try {
                class_2396<?> type = this.particleType;
                class_2394 options = type.method_10298().method_10296(type, new StringReader(" " + this.options.trim() + " "));
                this.emitter.spawnAtPosition(level, pos, options);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }
}

