/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;

@Environment(value=EnvType.CLIENT)
public class LevitationAnimation
extends PalladiumAnimation {
    public LevitationAnimation(int priority) {
        super(priority);
    }

    @Override
    public void animate(PalladiumAnimation.Builder builder, class_742 player, class_572<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean active;
        boolean bl = active = !firstPersonContext.firstPerson();
        if (active && player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getLevitationAnimation(partialTicks);
            if (anim <= 0.0f) {
                return;
            }
            builder.get(PalladiumAnimation.PlayerModelPart.BODY).setXRotDegrees(-15.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.HEAD).setXRotDegrees(-15.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setXRotDegrees(0.0f).setYRotDegrees(0.0f).setZRotDegrees(10.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setXRotDegrees(0.0f).setYRotDegrees(0.0f).setZRotDegrees(-10.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).resetX().resetY().resetZ().setXRotDegrees(10.0f).setYRotDegrees(0.0f).setZRotDegrees(2.5f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).resetX().resetY().resetZ().setXRotDegrees(5.0f).setYRotDegrees(0.0f).setZRotDegrees(-2.5f).animate(Easing.INOUTCUBIC, anim);
        }
    }
}

