/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.threetag.palladium.client.renderer.entity.PlayerSkinInfo;
import net.threetag.palladium.power.ability.PlayerSkinChangeAbility;
import net.threetag.palladium.power.ability.SkinChangeAbility;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinHandler {
    public static final List<Pair<Integer, ISkinProvider>> PROVIDER = new ArrayList<Pair<Integer, ISkinProvider>>();

    public static class_2960 getCurrentSkin(GameProfile gameProfile, class_2960 defaultSkin) {
        class_742 player = (class_742)Objects.requireNonNull(class_310.method_1551().field_1687).method_18470(gameProfile.getId());
        if (player instanceof PlayerSkinChangeHandler) {
            PlayerSkinChangeHandler handler = (PlayerSkinChangeHandler)player;
            PlayerSkinInfo skin = handler.palladium$getOverridenSkin();
            return skin != null ? skin.getTexture() : defaultSkin;
        }
        return defaultSkin;
    }

    public static String getCurrentModelType(GameProfile gameProfile, String modelType) {
        class_742 player = (class_742)Objects.requireNonNull(class_310.method_1551().field_1687).method_18470(gameProfile.getId());
        if (player instanceof PlayerSkinChangeHandler) {
            PlayerSkinChangeHandler handler = (PlayerSkinChangeHandler)player;
            PlayerSkinInfo skin = handler.palladium$getOverridenSkin();
            return skin != null ? skin.getModelName() : modelType;
        }
        return modelType;
    }

    public static void registerSkinProvider(int priority, ISkinProvider provider) {
        PROVIDER.add((Pair<Integer, ISkinProvider>)Pair.of((Object)priority, (Object)provider));
        PROVIDER.sort((p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst());
    }

    static {
        PlayerSkinHandler.registerSkinProvider(30, new SkinChangeAbility.SkinProvider());
        PlayerSkinHandler.registerSkinProvider(40, new PlayerSkinChangeAbility.SkinProvider());
    }

    public static interface PlayerSkinChangeHandler {
        @Nullable
        public PlayerSkinInfo palladium$getOverridenSkin();
    }

    public static interface ISkinProvider {
        public PlayerSkinInfo getSkin(class_742 var1, PlayerSkinInfo var2, PlayerSkinInfo var3);
    }
}

