/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.item.armor;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_918;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.compat.geckolib.GeckoLibCompat;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.util.Platform;

public class ArmorRendererManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final List<ArmorWithRenderer> EXTENDED_ARMOR_ITEMS = new ArrayList<ArmorWithRenderer>();
    public static final Map<ArmorWithRenderer, ArmorRendererData> LEGACY_SUPPORT = new HashMap<ArmorWithRenderer, ArmorRendererData>();
    private static boolean LOOK_FOR_ITEMS = false;
    public static ArmorRendererManager INSTANCE;
    public Map<class_2960, ArmorRendererData> byName = ImmutableMap.of();

    public ArmorRendererManager() {
        super(GSON, "palladium/armor_renderers");
        INSTANCE = this;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        if (!LOOK_FOR_ITEMS) {
            for (class_1792 item : class_7923.field_41178) {
                if (!(item instanceof ArmorWithRenderer)) continue;
                ArmorWithRenderer armor = (ArmorWithRenderer)item;
                EXTENDED_ARMOR_ITEMS.add(armor);
            }
            LOOK_FOR_ITEMS = true;
        }
        EXTENDED_ARMOR_ITEMS.forEach(i -> i.setCachedArmorRenderer(null));
        class_5599 entityModelSet = class_310.method_1551().method_31974();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((id, json) -> {
            try {
                ArmorRendererData data = ArmorRendererData.fromJson(class_3518.method_15295((JsonElement)json, (String)"$"));
                data.buildModels(entityModelSet);
                builder.put(id, (Object)data);
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading armor renderer {}", id, e);
            }
        });
        this.byName = builder.build();
        EXTENDED_ARMOR_ITEMS.forEach(i -> {
            ArmorRendererData renderer = this.byName.get(i.getArmorRendererFile());
            ArmorRendererData legacyRenderer = LEGACY_SUPPORT.get(i);
            if (renderer == null && legacyRenderer == null) {
                i.setCachedArmorRenderer(null);
            } else if (renderer != null && legacyRenderer == null) {
                i.setCachedArmorRenderer(renderer);
            } else {
                i.setCachedArmorRenderer(Objects.requireNonNullElse(renderer, legacyRenderer));
            }
        });
        AddonPackLog.info("Loaded {} armor renderers", this.byName.size());
    }

    public static void renderFirstPerson(class_742 player, class_4587 poseStack, class_4597 buffer, int combinedLight, class_630 rendererArm, boolean rightArm) {
        ArmorWithRenderer item;
        Object object;
        class_1799 stack = player.method_6118(class_1304.field_6174);
        if (!stack.method_7960() && (object = stack.method_7909()) instanceof ArmorWithRenderer && (object = (item = (ArmorWithRenderer)object).getCachedArmorRenderer()) instanceof ArmorRendererData) {
            ArmorRendererData renderer = (ArmorRendererData)object;
            DataContext context = DataContext.forArmorInSlot((class_1309)player, class_1304.field_6174);
            class_572<?> armorModel = renderer.getModel((class_1309)player, context);
            class_4588 vertex = class_918.method_27952((class_4597)buffer, (class_1921)PalladiumRenderTypes.getArmorTranslucent(renderer.getTexture(context)), (boolean)false, (boolean)stack.method_7958());
            class_630 arm = rightArm ? armorModel.field_3401 : armorModel.field_27433;
            arm.method_17138(rendererArm);
            arm.field_3654 = 0.0f;
            arm.method_22698(poseStack, vertex, combinedLight, class_4608.field_21444);
            if (armorModel instanceof class_591) {
                class_591 playerModel = (class_591)armorModel;
                arm = rightArm ? playerModel.field_3486 : playerModel.field_3484;
                arm.method_17138(rendererArm);
                arm.field_3654 = 0.0f;
                arm.method_22698(poseStack, vertex, combinedLight, class_4608.field_21444);
            }
        }
        if (!stack.method_7960() && Platform.isModLoaded((String)"geckolib")) {
            GeckoLibCompat.renderFirstPerson(player, stack, poseStack, buffer, combinedLight, rendererArm, rightArm);
        }
    }
}

