/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import java.awt.Color;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.model.ThrusterHumanoidModel;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class ThrusterPackRenderLayer
extends AbstractPackRenderLayer {
    public static final class_5601 MODEL_LAYER_LOCATION = new class_5601(Palladium.id("humanoid"), "thrusters");
    public static final class_5601 MODEL_LAYER_LOCATION_SLIM = new class_5601(Palladium.id("humanoid"), "thrusters_slim");
    public static final class_2960[] TEXTURES = new class_2960[8];
    private static final DynamicColor DEFAULT_COLOR = DynamicColor.staticColor(new Color(234, 182, 43));
    private final SkinTypedValue<ThrusterHumanoidModel<?>> model = new SkinTypedValue(new ThrusterHumanoidModel(class_310.method_1551().method_31974().method_32072(MODEL_LAYER_LOCATION)), new ThrusterHumanoidModel(class_310.method_1551().method_31974().method_32072(MODEL_LAYER_LOCATION_SLIM)));
    private final boolean rightArm;
    private final boolean leftArm;
    private final boolean rightLeg;
    private final boolean leftLeg;
    private final DynamicColor color;

    public ThrusterPackRenderLayer(boolean rightArm, boolean leftArm, boolean rightLeg, boolean leftLeg, DynamicColor color) {
        this.rightArm = rightArm;
        this.leftArm = leftArm;
        this.rightLeg = rightLeg;
        this.leftLeg = leftLeg;
        this.color = color;
    }

    @Override
    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_583<class_1297> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1309 entity = context.getLivingEntity();
        if (entity != null && IPackRenderLayer.conditionsFulfilled((class_1297)entity, this.conditions, this.thirdPersonConditions)) {
            ThrusterHumanoidModel<?> model = this.model.get((class_1297)entity);
            if (parentModel instanceof class_572) {
                class_572 parentHumanoid = (class_572)parentModel;
                IPackRenderLayer.copyModelProperties((class_1297)entity, parentHumanoid, model);
            }
            model.extraAnimations(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks);
            model.rightArmThruster.field_3665 = this.rightArm;
            model.leftArmThruster.field_3665 = this.leftArm;
            model.rightLegThruster.field_3665 = this.rightLeg;
            model.leftLegThruster.field_3665 = this.leftLeg;
            class_4588 vertexConsumer = bufferSource.getBuffer(PalladiumRenderTypes.getGlowing(TEXTURES[entity.field_6012 / 2 % TEXTURES.length]));
            Color color = this.color.getColor(context);
            model.method_2828(poseStack, vertexConsumer, 0xF00000, class_4608.field_21444, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, class_1306 arm, class_1007 playerRenderer, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        super.renderArm(context, arm, playerRenderer, poseStack, bufferSource, packedLight);
    }

    public static ThrusterPackRenderLayer parse(JsonObject json) {
        return new ThrusterPackRenderLayer(class_3518.method_15258((JsonObject)json, (String)"right_arm", (boolean)true), class_3518.method_15258((JsonObject)json, (String)"left_arm", (boolean)true), class_3518.method_15258((JsonObject)json, (String)"right_leg", (boolean)true), class_3518.method_15258((JsonObject)json, (String)"left_leg", (boolean)true), DynamicColor.getFromJson(json, "color", DEFAULT_COLOR));
    }

    static {
        for (int i = 0; i < TEXTURES.length; ++i) {
            ThrusterPackRenderLayer.TEXTURES[i] = Palladium.id("textures/models/thruster/" + i + ".png");
        }
    }
}

