/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Matrix4f;

public class GradientTrailRenderer
extends TrailRenderer<TrailRenderer.SegmentCache> {
    private final float spacing;
    private final int lifetime;
    private final DynamicColor color;
    private final float opacity;
    private final boolean normalTransparency;

    public GradientTrailRenderer(float spacing, int lifetime, DynamicColor color, float opacity, boolean normalTransparency) {
        this.spacing = spacing;
        this.lifetime = lifetime;
        this.color = color;
        this.opacity = opacity;
        this.normalTransparency = normalTransparency;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, TrailSegmentEntityRenderer trailRenderer, class_1297 livingEntity, TrailSegmentEntity<TrailRenderer.SegmentCache> segment, float partialTick, float entityYaw) {
        PalladiumEntityExtension ext;
        List<TrailSegmentEntity<?>> trails;
        int index;
        if (livingEntity instanceof PalladiumEntityExtension && (index = (trails = (ext = (PalladiumEntityExtension)livingEntity).palladium$getTrailHandler().getTrails().get(this)).indexOf(segment)) > 0) {
            TrailSegmentEntity<?> prev;
            class_4588 vertexConsumer = buffer.getBuffer(this.normalTransparency ? PalladiumRenderTypes.LASER_NORMAL_TRANSPARENCY : PalladiumRenderTypes.LASER);
            Color color = this.color.getColor(DataContext.forEntity(livingEntity));
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            float segmentOpacity = 1.0f - class_3532.method_15363((float)(((float)segment.field_6012 + partialTick) / (float)segment.lifetime), (float)0.0f, (float)1.0f);
            if (index == trails.size() - 1) {
                poseStack.method_22903();
                class_243 endPos = livingEntity.method_30950(partialTick).method_1020(segment.method_19538());
                Matrix4f matrix = poseStack.method_23760().method_23761();
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, this.opacity * segmentOpacity).method_22916(packedLight).method_1344();
                vertexConsumer.method_22918(matrix, 0.0f, segment.method_17682(), 0.0f).method_22915(r, g, b, this.opacity * segmentOpacity).method_22916(packedLight).method_1344();
                vertexConsumer.method_22918(matrix, (float)endPos.field_1352, (float)(endPos.field_1351 + (double)livingEntity.method_17682()), (float)endPos.field_1350).method_22915(r, g, b, this.opacity * segmentOpacity).method_22916(packedLight).method_1344();
                vertexConsumer.method_22918(matrix, (float)endPos.field_1352, (float)endPos.field_1351, (float)endPos.field_1350).method_22915(r, g, b, this.opacity * segmentOpacity).method_22916(packedLight).method_1344();
                poseStack.method_22909();
            }
            if (!(prev = trails.get(index - 1)).method_5805()) {
                return;
            }
            class_243 endPos = prev.method_19538().method_1020(segment.method_19538());
            float prevOpacity = 1.0f - class_3532.method_15363((float)(((float)prev.field_6012 + partialTick) / (float)prev.lifetime), (float)0.0f, (float)1.0f);
            poseStack.method_22903();
            Matrix4f matrix = poseStack.method_23760().method_23761();
            vertexConsumer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, this.opacity * segmentOpacity).method_22916(packedLight).method_1344();
            vertexConsumer.method_22918(matrix, 0.0f, segment.method_17682(), 0.0f).method_22915(r, g, b, this.opacity * segmentOpacity).method_22916(packedLight).method_1344();
            vertexConsumer.method_22918(matrix, (float)endPos.field_1352, (float)(endPos.field_1351 + (double)prev.method_17682()), (float)endPos.field_1350).method_22915(r, g, b, this.opacity * prevOpacity).method_22916(packedLight).method_1344();
            vertexConsumer.method_22918(matrix, (float)endPos.field_1352, (float)endPos.field_1351, (float)endPos.field_1350).method_22915(r, g, b, this.opacity * prevOpacity).method_22916(packedLight).method_1344();
            poseStack.method_22909();
        }
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public DynamicColor getColor() {
        return this.color;
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        @Override
        public TrailRenderer<?> parse(JsonObject json) {
            DynamicColor color = DynamicColor.getFromJson(json, "color", DynamicColor.WHITE);
            float spacing = GsonUtil.getAsFloatMin(json, "spacing", 0.1f, 1.0f);
            int lifetime = GsonUtil.getAsIntMin(json, "lifetime", 1, 20);
            float opacity = GsonUtil.getAsFloatRanged(json, "opacity", 0.0f, 1.0f, 0.5f);
            boolean normalTransparency = class_3518.method_15258((JsonObject)json, (String)"normal_transparency", (boolean)false);
            return new GradientTrailRenderer(spacing, lifetime, color, opacity, normalTransparency);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Gradient Trail");
            builder.setDescription("Renders a simple, colored gradient trail.");
            builder.addProperty("color", Color.class).description("Determines the tint/color of the gradient").fallback(Color.WHITE, "#ffffff").exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
            builder.addProperty("spacing", Float.class).description("Determines the space between two trail segments").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("lifetime", Integer.class).description("Determines how long one trail segment stays alive (in ticks)").fallback(20).exampleJson((JsonElement)new JsonPrimitive((Number)20));
            builder.addProperty("opacity", Float.class).description("Determines the (initial) opacity of the after image.").fallback(Float.valueOf(0.5f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.5f)));
            builder.addProperty("normal_transparency", Boolean.class).description("Can be turned on if you want to make a gradient black.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("gradient");
        }
    }
}

