/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;

@Environment(value=EnvType.CLIENT)
public enum PowerTabType {
    ABOVE(0, 0, 28, 32, 8),
    BELOW(84, 0, 28, 32, 8),
    LEFT(0, 64, 32, 28, 5),
    RIGHT(96, 64, 32, 28, 5);

    public static final int MAX_TABS;
    private final int textureX;
    private final int textureY;
    private final int width;
    private final int height;
    private final int max;

    private PowerTabType(int j, int k, int l, int m, int n2) {
        this.textureX = j;
        this.textureY = k;
        this.width = l;
        this.height = m;
        this.max = n2;
    }

    public int getMax() {
        return this.max;
    }

    public void draw(class_332 guiGraphics, int offsetX, int offsetY, boolean isSelected, int index) {
        int i = this.textureX;
        if (index > 0) {
            i += this.width;
        }
        if (index == this.max - 1) {
            i += this.width;
        }
        int j = isSelected ? this.textureY + this.height : this.textureY;
        guiGraphics.method_25302(PowersScreen.TABS, offsetX + this.getX(index), offsetY + this.getY(index), i, j, this.width, this.height);
    }

    public void drawIcon(class_332 guiGraphics, DataContext context, int offsetX, int offsetY, int index, IIcon icon) {
        int i = offsetX + this.getX(index);
        int j = offsetY + this.getY(index);
        switch (this) {
            case ABOVE: {
                i += 6;
                j += 9;
                break;
            }
            case BELOW: {
                i += 6;
                j += 6;
                break;
            }
            case LEFT: {
                i += 10;
                j += 5;
                break;
            }
            case RIGHT: {
                i += 6;
                j += 5;
            }
        }
        icon.draw(class_310.method_1551(), guiGraphics, context, i, j);
    }

    public int getX(int index) {
        switch (this) {
            case ABOVE: 
            case BELOW: {
                return (this.width + 4) * index;
            }
            case LEFT: {
                return -this.width + 4;
            }
            case RIGHT: {
                return 248;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + String.valueOf((Object)this));
    }

    public int getY(int index) {
        switch (this) {
            case ABOVE: {
                return -this.height + 4;
            }
            case BELOW: {
                return 192;
            }
            case LEFT: 
            case RIGHT: {
                return this.height * index;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + String.valueOf((Object)this));
    }

    public boolean isMouseOver(int offsetX, int offsetY, int index, double mouseX, double mouseY) {
        int i = offsetX + this.getX(index);
        int j = offsetY + this.getY(index);
        return mouseX > (double)i && mouseX < (double)(i + this.width) && mouseY > (double)j && mouseY < (double)(j + this.height);
    }

    static {
        MAX_TABS = Arrays.stream(PowerTabType.values()).mapToInt(e -> e.max).sum();
    }
}

