/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.threetag.palladium.command.SuperpowerCommand;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;
import net.threetag.palladium.power.energybar.EnergyBarReference;

public class EnergyBarCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_OWN_POWERS = (context, builder) -> {
        class_3222 entity;
        ArrayList powers = Lists.newArrayList();
        try {
            context.getArgument("entity", class_2300.class);
            entity = class_2186.method_9313((CommandContext)context, (String)"entity");
        }
        catch (Exception e) {
            entity = ((class_2168)context.getSource()).method_9207();
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            PowerHandler manager = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living));
            for (IPowerHolder holder : manager.getPowerHolders().values()) {
                if (holder.getEnergyBars().isEmpty()) continue;
                powers.add(holder.getPower().getId());
            }
        }
        return class_2172.method_9270((Iterable)powers, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> SUGGEST_ENERGY_BAR = (context, builder) -> {
        ArrayList energyBars = Lists.newArrayList();
        Power power = null;
        try {
            context.getArgument("power", class_2960.class);
            power = SuperpowerCommand.getSuperpower((CommandContext<class_2168>)context, "power");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (power != null) {
            for (EnergyBarConfiguration energyBar : power.getEnergyBars()) {
                energyBars.add(energyBar.getName());
            }
        }
        return class_2172.method_9265((Iterable)energyBars, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"energybar").requires(player -> player.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"value").then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).executes(context -> EnergyBarCommand.getEnergyBarValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar")))))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EnergyBarCommand.setEnergyBarValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EnergyBarCommand.addEnergyBarValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(class_2170.method_9247((String)"subtract").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EnergyBarCommand.addEnergyBarValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), -IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"max").then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).executes(context -> EnergyBarCommand.getEnergyBarMaxValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar")))))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> EnergyBarCommand.setEnergyBarMaxValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).executes(context -> EnergyBarCommand.resetEnergyBarMaxValue((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), class_2232.method_9443((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar")))))))));
    }

    public static int getEnergyBarValue(class_2168 source, class_1297 entity, class_2960 powerId, String energyBarName) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.energybar.value.get.success", (Object[])new Object[]{entity.method_5476(), powerId.toString(), energyBarName, bar.get()}), true);
                return bar.get();
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int setEnergyBarValue(class_2168 source, class_1297 entity, class_2960 powerId, String energyBarName, int value) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.set(value);
                source.method_9226(() -> class_2561.method_43469((String)"commands.energybar.value.set.success", (Object[])new Object[]{entity.method_5476(), powerId.toString(), energyBarName, bar.get()}), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int addEnergyBarValue(class_2168 source, class_1297 entity, class_2960 powerId, String energyBarName, int value) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.add(value);
                source.method_9226(() -> class_2561.method_43469((String)"commands.energybar.value.set.success", (Object[])new Object[]{entity.method_5476(), powerId.toString(), energyBarName, bar.get()}), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int getEnergyBarMaxValue(class_2168 source, class_1297 entity, class_2960 powerId, String energyBarName) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.energybar.maxValue.get.success", (Object[])new Object[]{entity.method_5476(), powerId.toString(), energyBarName, bar.getMax()}), true);
                return bar.getMax();
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int setEnergyBarMaxValue(class_2168 source, class_1297 entity, class_2960 powerId, String energyBarName, int value) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.setOverriddenMaxValue(value);
                source.method_9226(() -> class_2561.method_43469((String)"commands.energybar.maxValue.set.success", (Object[])new Object[]{entity.method_5476(), powerId.toString(), energyBarName, bar.getMax()}), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int resetEnergyBarMaxValue(class_2168 source, class_1297 entity, class_2960 powerId, String energyBarName) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.setOverriddenMaxValue(-1);
                source.method_9226(() -> class_2561.method_43469((String)"commands.energybar.maxValue.reset.success", (Object[])new Object[]{entity.method_5476(), powerId.toString(), energyBarName, bar.getMax()}), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }
}

