/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2303;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.threetag.palladium.command.EntitySelectorParserExtension;
import net.threetag.palladium.mixin.EntitySelectorOptionsInvoker;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladiumcore.util.Platform;

public class PalladiumEntitySelectorOptions {
    public static final class_2561 POWER_DESCRIPTION = class_2561.method_43471((String)"argument.entity.options.palladium.power.description");

    public static void init() {
        EntitySelectorOptionsInvoker.callRegister("palladium.power", parser -> PalladiumEntitySelectorOptions.cast(parser).palladium$setPower(PalladiumEntitySelectorOptions.parsePowerId(parser)), parser -> PalladiumEntitySelectorOptions.cast(parser).palladium$getPower() == null, POWER_DESCRIPTION);
    }

    private static EntitySelectorParserExtension cast(class_2303 parser) {
        return (EntitySelectorParserExtension)parser;
    }

    private static class_2960 parsePowerId(class_2303 parser) throws CommandSyntaxException {
        PowerManager powers = PowerManager.getInstance(Platform.isServer());
        parser.method_9875((builder, consumer) -> {
            PalladiumEntitySelectorOptions.suggestIdentifiersIgnoringNamespace("palladium", powers.getIds(), builder);
            return builder.buildFuture();
        });
        return class_2960.method_12835((StringReader)parser.method_9835());
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<class_2960> candidates, SuggestionsBuilder builder) {
        PalladiumEntitySelectorOptions.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, class_2960> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            class_2960 id = idFunc.apply(object);
            if (hasColon) {
                if (!PalladiumEntitySelectorOptions.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!PalladiumEntitySelectorOptions.wordStartsWith(string, id.method_12836(), '_') && (!id.method_12836().equals(namespace) || !PalladiumEntitySelectorOptions.wordStartsWith(string, id.method_12832(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

