/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotProperty;

public class EmptySlotCondition
extends Condition {
    private final PlayerSlot slot;

    public EmptySlotCondition(PlayerSlot slot) {
        this.slot = slot;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        for (class_1799 item : this.slot.getItems(entity)) {
            if (item.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.EMPTY_SLOT.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<PlayerSlot> SLOT = new PlayerSlotProperty("slot").configurable("Slot that must be empty");

        public Serializer() {
            this.withProperty(SLOT, PlayerSlot.get(class_1304.field_6174.method_5923()));
        }

        @Override
        public Condition make(JsonObject json) {
            return new EmptySlotCondition(this.getProperty(json, SLOT));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the given slot is empty.";
        }
    }
}

