/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1297;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class FloatPropertyCondition
extends Condition {
    private final String propertyKey;
    private final float min;
    private final float max;

    public FloatPropertyCondition(String propertyKey, float min, float max) {
        this.propertyKey = propertyKey;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean active(DataContext context) {
        class_1297 entity = context.get(DataContextType.ENTITY);
        if (entity == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        EntityPropertyHandler.getHandler(entity).ifPresent(handler -> {
            PalladiumProperty<?> property = handler.getPropertyByName(this.propertyKey);
            if (property instanceof FloatProperty) {
                FloatProperty floatProperty = (FloatProperty)property;
                float value = handler.get(floatProperty).floatValue();
                result.set(value >= this.min && value <= this.max);
            }
        });
        return result.get();
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.FLOAT_PROPERTY.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> PROPERTY = new StringProperty("property").configurable("Name of the float property in the entity");
        public static final PalladiumProperty<Float> MIN = new FloatProperty("min").configurable("Minimum required amount of the property value");
        public static final PalladiumProperty<Float> MAX = new FloatProperty("max").configurable("Maximum required amount of the property value");

        public Serializer() {
            this.withProperty(PROPERTY, "value");
            this.withProperty(MIN, Float.valueOf(0.0f));
            this.withProperty(MAX, Float.valueOf(0.0f));
        }

        @Override
        public Condition make(JsonObject json) {
            return new FloatPropertyCondition(this.getProperty(json, PROPERTY), this.getProperty(json, MIN).floatValue(), this.getProperty(json, MAX).floatValue());
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity has a float property with a value between the given minimum and maximum.";
        }
    }
}

