/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.IngredientProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotProperty;

public class ItemInSlotCondition
extends Condition {
    private final class_1856 ingredient;
    private final PlayerSlot slot;

    public ItemInSlotCondition(class_1856 ingredient, PlayerSlot slot) {
        this.ingredient = ingredient;
        this.slot = slot;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        for (class_1799 item : this.slot.getItems(entity)) {
            if (!this.ingredient.method_8093(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ITEM_IN_SLOT.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<class_1856> ITEM = new IngredientProperty("item").configurable("Item (defined as an ingredient) that must be in the given slot");
        public static final PalladiumProperty<PlayerSlot> SLOT = new PlayerSlotProperty("slot").configurable("Slot that must contain the item");

        public Serializer() {
            this.withProperty(ITEM, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8577}));
            this.withProperty(SLOT, PlayerSlot.get(class_1304.field_6174.method_5923()));
        }

        @Override
        public Condition make(JsonObject json) {
            return new ItemInSlotCondition(this.getProperty(json, ITEM), this.getProperty(json, SLOT));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the given item is in the given slot.";
        }
    }
}

