/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_266;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class ObjectiveScoreCondition
extends Condition {
    private final String objectiveName;
    private final int min;
    private final int max;

    public ObjectiveScoreCondition(String objectiveName, int min, int max) {
        this.objectiveName = objectiveName;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean active(DataContext context) {
        class_1297 entity = context.get(DataContextType.ENTITY);
        if (entity == null) {
            return false;
        }
        class_266 objective = entity.method_37908().method_8428().method_1170(this.objectiveName);
        if (objective != null) {
            if (!entity.method_37908().method_8428().method_1183(entity.method_5820(), objective)) {
                return false;
            }
            int score = entity.method_37908().method_8428().method_1180(entity.method_5820(), objective).method_1126();
            return score >= this.min && score <= this.max;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.OBJECTIVE_SCORE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> OBJECTIVE = new StringProperty("objective").configurable("Name of the objective");
        public static final PalladiumProperty<Integer> MIN = new IntegerProperty("min_score").configurable("Minimum required score of objective");
        public static final PalladiumProperty<Integer> MAX = new IntegerProperty("max_score").configurable("Maximum required score of objective");

        public Serializer() {
            this.withProperty(OBJECTIVE, "objective_name");
            this.withProperty(MIN, Integer.MIN_VALUE);
            this.withProperty(MAX, Integer.MAX_VALUE);
        }

        @Override
        public Condition make(JsonObject json) {
            return new ObjectiveScoreCondition(this.getProperty(json, OBJECTIVE), this.getProperty(json, MIN), this.getProperty(json, MAX));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the player has a score in a specific objective. IF YOU USE THIS, MAKE A 'tracked_score.json' AND PUT THE OBJECTIVE NAME IN IT, MORE ON THE WIKI!";
        }
    }
}

