/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.energy.fabric;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.threetag.palladium.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class EnergyHelperImpl {
    public static Optional<IEnergyStorage> getFromItemStack(class_1799 stack) {
        EnergyStorage storage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        return storage == null ? Optional.empty() : Optional.of(new Wrapper(storage));
    }

    public static Optional<IEnergyStorage> getFromBlockEntity(class_1937 level, class_2338 pos, @Nullable class_2350 side) {
        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, pos, (Object)side);
        return Optional.ofNullable(energyStorage == null ? null : new Wrapper(energyStorage));
    }

    public static long moveBetweenBlockEntities(class_1937 level, class_2338 from, class_2350 fromSide, class_2338 to, class_2350 toSide, long maxAmount) {
        EnergyStorage fromStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, from, (Object)fromSide);
        EnergyStorage toStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, to, (Object)toSide);
        return EnergyStorageUtil.move((EnergyStorage)fromStorage, (EnergyStorage)toStorage, (long)maxAmount, null);
    }

    public record Wrapper(EnergyStorage fabricStorage) implements IEnergyStorage
    {
        @Override
        public boolean canInsert() {
            return this.fabricStorage.supportsInsertion();
        }

        @Override
        public int insertEnergy(int maxAmount, boolean simulate) {
            return (int)this.fabricStorage.insert((long)maxAmount, (TransactionContext)Transaction.openNested(null));
        }

        @Override
        public boolean canWithdraw() {
            return this.fabricStorage.supportsExtraction();
        }

        @Override
        public int withdrawEnergy(int maxAmount, boolean simulate) {
            return (int)this.fabricStorage.extract((long)maxAmount, (TransactionContext)Transaction.openNested(null));
        }

        @Override
        public int getEnergyAmount() {
            return (int)this.fabricStorage.getAmount();
        }

        @Override
        public int getEnergyCapacity() {
            return (int)this.fabricStorage.getCapacity();
        }
    }
}

