/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.sound.FlightSound;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladiumcore.util.Platform;

public class FlightHandler {
    public static Object CACHED_SOUND = null;
    private final class_1657 player;
    private class_243 prevMovementDelta = null;
    private FlightType flightType = FlightType.NONE;
    private float flightSpeed = 1.0f;
    private boolean didFlew = false;
    public float flightBoost = 0.0f;
    private float prevFlightBoost = 0.0f;
    private int verticalHover = 0;
    private float levitation = 0.0f;
    private float prevLevitation = 0.0f;
    private float hovering = 0.0f;
    private float prevHovering = 0.0f;
    private class_243 flightVector = class_243.field_1353;
    private class_243 prevFlightVector = class_243.field_1353;
    private class_243 prevLookAngle = class_243.field_1353;
    private float speed = 0.0f;
    private float prevSpeed = 0.0f;
    private float horizontalSpeed = 0.0f;
    private float prevHorizontalSpeed = 0.0f;

    public FlightHandler(class_1657 player) {
        this.player = player;
    }

    public void tick() {
        this.prevMovementDelta = this.player.method_18798();
        this.prevFlightBoost = this.flightBoost;
        this.prevLevitation = this.levitation;
        this.prevHovering = this.hovering;
        this.prevSpeed = this.speed;
        this.speed = (float)Math.sqrt(this.prevMovementDelta.field_1352 * this.prevMovementDelta.field_1352 + this.prevMovementDelta.field_1351 * this.prevMovementDelta.field_1351 + this.prevMovementDelta.field_1350 * this.prevMovementDelta.field_1350);
        this.prevHorizontalSpeed = this.horizontalSpeed;
        this.horizontalSpeed = (float)Math.sqrt(this.prevMovementDelta.field_1352 * this.prevMovementDelta.field_1352 + this.prevMovementDelta.field_1350 * this.prevMovementDelta.field_1350);
        this.prevLookAngle = this.player.method_5720();
        this.prevFlightVector = this.flightVector;
        if (this.flightType.isNotNull() && (this.player.method_24828() || this.player.method_6128() || this.player.method_5681() || this.player.method_26825(this.flightType.getAttribute()) <= 0.0)) {
            this.flightType = FlightType.NONE;
        }
        if (this.flightType.isNotNull()) {
            if (this.player.method_5624() && this.flightType == FlightType.NORMAL) {
                if (PalladiumProperties.FORWARD_KEY_DOWN.get((class_1297)this.player).booleanValue() && this.flightBoost < 3.0f) {
                    this.flightBoost = Math.min(3.0f, this.flightBoost + 0.2f);
                } else if (!PalladiumProperties.FORWARD_KEY_DOWN.get((class_1297)this.player).booleanValue() && this.flightBoost > 0.0f) {
                    this.flightBoost = Math.max(0.0f, this.flightBoost - 0.4f);
                }
                this.didFlew = true;
            } else if (PalladiumProperties.FORWARD_KEY_DOWN.get((class_1297)this.player).booleanValue() && this.flightBoost < 1.0f) {
                this.flightBoost = Math.min(1.0f, this.flightBoost + 0.05f);
                this.didFlew = false;
            } else if (!PalladiumProperties.FORWARD_KEY_DOWN.get((class_1297)this.player).booleanValue() && this.flightBoost > 0.0f) {
                this.flightBoost = Math.max(0.0f, this.flightBoost - 0.1f);
            }
            this.levitation = this.didFlew ? 0.0f : class_3532.method_15363((float)(this.horizontalSpeed * 2.0f), (float)0.0f, (float)1.0f);
        } else {
            this.hovering = 0.0f;
            this.levitation = 0.0f;
            this.flightBoost = 0.0f;
            this.didFlew = false;
        }
        if (this.flightBoost > 0.0f) {
            class_243 sideVec;
            if (this.flightType.isNotNull()) {
                this.flightSpeed = (float)this.player.method_26825(this.flightType.getAttribute());
            }
            if (this.hovering < 1.0f) {
                this.hovering = Math.min(1.0f, this.hovering + 0.1f);
            }
            class_243 look = this.player.method_5720().method_1021((double)(this.flightBoost / 2.0f * this.flightSpeed));
            if (PalladiumProperties.LEFT_KEY_DOWN.get((class_1297)this.player).booleanValue()) {
                sideVec = this.player.method_5720().method_1024((float)Math.toRadians(90.0)).method_1029();
                look = look.method_1031(sideVec.field_1352, 0.0, sideVec.field_1350);
            }
            if (PalladiumProperties.RIGHT_KEY_DOWN.get((class_1297)this.player).booleanValue()) {
                sideVec = this.player.method_5720().method_1024((float)Math.toRadians(-90.0)).method_1029();
                look = look.method_1031(sideVec.field_1352, 0.0, sideVec.field_1350);
            }
            class_243 diff = look.method_1020(this.flightVector);
            double flexibility = (10.0 - this.player.method_26825((class_1320)PalladiumAttributes.FLIGHT_FLEXIBILITY.get())) / 100.0;
            diff = diff.method_1033() > flexibility ? diff.method_1021(flexibility / diff.method_1033()) : diff;
            this.flightVector = this.flightVector.method_1019(diff);
            this.player.method_18799(this.flightVector);
            this.player.field_6017 = 0.0f;
            this.verticalHover = 0;
        } else if (this.flightType.isNotNull()) {
            this.didFlew = false;
            if (PalladiumProperties.JUMP_KEY_DOWN.get((class_1297)this.player).booleanValue()) {
                if (this.verticalHover < 20) {
                    this.verticalHover = class_3532.method_15340((int)(this.verticalHover + 1), (int)-20, (int)20);
                }
            } else if (this.player.method_18276()) {
                if (this.verticalHover > -20) {
                    this.verticalHover = class_3532.method_15340((int)(this.verticalHover - 1), (int)-20, (int)20);
                }
            } else if (this.verticalHover != 0) {
                this.verticalHover = class_3532.method_15340((int)(this.verticalHover + (this.verticalHover > 0 ? -1 : 1)), (int)-20, (int)20);
            }
            this.player.method_18799(new class_243(this.player.method_18798().field_1352, (double)this.verticalHover == 0.0 ? Math.sin((float)this.player.field_6012 / 10.0f) / 100.0 : (double)this.verticalHover / 60.0, this.player.method_18798().field_1350));
            this.player.field_6017 = 0.0f;
            this.flightVector = class_243.field_1353;
            if (this.hovering < 1.0f) {
                this.hovering = Math.min(1.0f, this.hovering + 0.1f);
            }
        } else {
            this.didFlew = false;
            this.verticalHover = 0;
            this.flightVector = class_243.field_1353;
            if (this.hovering > 0.0f) {
                this.hovering = Math.max(0.0f, this.hovering - 0.1f);
            }
        }
        if (this.flightBoost > 1.0f && this.prevFlightBoost <= 1.0f || this.flightBoost <= 1.0f && this.prevFlightBoost > 1.0f) {
            this.player.method_18382();
            if (this.flightBoost > 1.0f && this.prevFlightBoost <= 1.0f && Platform.isClient()) {
                FlightHandler.startSound(this.player);
            }
        }
    }

    public class_243 getPrevMovementDelta() {
        return this.prevMovementDelta;
    }

    public FlightType getFlightType() {
        return this.flightType;
    }

    public void setFlightType(FlightType flightType) {
        this.flightType = flightType;
        class_1320 attribute = flightType.getAttribute();
        if (attribute != null) {
            this.flightSpeed = (float)this.player.method_26825(attribute);
        }
        if (this.player.method_5624()) {
            this.flightBoost = 1.0f;
        }
        this.player.method_18382();
    }

    public float getFlightAnimation(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevFlightBoost, (float)this.flightBoost);
    }

    public float getLevitationAnimation(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevLevitation, (float)this.levitation);
    }

    public float getHoveringAnimation(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevHovering, (float)this.hovering);
    }

    public class_243 getFlightVector(float partialTicks) {
        return this.prevFlightVector.method_35590(this.flightVector, (double)partialTicks);
    }

    public class_243 getLookAngle(float partialTicks) {
        return this.prevLookAngle.method_35590(this.player.method_5720(), (double)partialTicks);
    }

    public float getSpeed(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevSpeed, (float)this.speed);
    }

    public float getHorizontalSpeed(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevHorizontalSpeed, (float)this.horizontalSpeed);
    }

    public static FlightType getAvailableFlightType(class_1309 entity) {
        if (entity.method_6127().method_27306((class_1320)PalladiumAttributes.FLIGHT_SPEED.get()) && entity.method_26825((class_1320)PalladiumAttributes.FLIGHT_SPEED.get()) > 0.0) {
            return FlightType.NORMAL;
        }
        if (entity.method_6127().method_27306((class_1320)PalladiumAttributes.LEVITATION_SPEED.get()) && entity.method_26825((class_1320)PalladiumAttributes.LEVITATION_SPEED.get()) > 0.0) {
            return FlightType.LEVITATION;
        }
        return FlightType.NONE;
    }

    public static FlightAnimationType getAnimationType(class_1309 entity) {
        if (entity.method_6127().method_27306((class_1320)PalladiumAttributes.HEROIC_FLIGHT_TYPE.get()) && entity.method_26825((class_1320)PalladiumAttributes.HEROIC_FLIGHT_TYPE.get()) > 0.0) {
            return FlightAnimationType.HEROIC;
        }
        return FlightAnimationType.NORMAL;
    }

    @Environment(value=EnvType.CLIENT)
    public static void startSound(class_1657 player) {
        if (player == class_310.method_1551().field_1724) {
            Object object = CACHED_SOUND;
            if (object instanceof FlightSound) {
                FlightSound sound = (FlightSound)((Object)object);
                sound.stop = true;
            }
            CACHED_SOUND = new FlightSound((class_1309)player, class_3417.field_14572, player.method_5634());
            class_310.method_1551().method_1483().method_4873((class_1113)CACHED_SOUND);
        }
    }

    public static enum FlightType {
        NONE(() -> null),
        NORMAL((Supplier<class_1320>)PalladiumAttributes.FLIGHT_SPEED),
        LEVITATION((Supplier<class_1320>)PalladiumAttributes.LEVITATION_SPEED);

        private final Supplier<class_1320> attributeSupplier;

        private FlightType(Supplier<class_1320> attributeSupplier) {
            this.attributeSupplier = attributeSupplier;
        }

        public class_1320 getAttribute() {
            return this.attributeSupplier.get();
        }

        public boolean isNotNull() {
            return this != NONE;
        }

        public boolean isNull() {
            return this == NONE;
        }

        public boolean isNormal() {
            return this == NORMAL;
        }

        public boolean isLevitation() {
            return this == LEVITATION;
        }
    }

    public static enum FlightAnimationType {
        NORMAL,
        HEROIC;

    }
}

