/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.threetag.palladium.client.renderer.trail.CompoundTrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.entity.CustomProjectile;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.TrailAbility;

public class TrailHandler {
    private final class_1297 entity;
    private Map<TrailRenderer<?>, List<TrailSegmentEntity<?>>> trails = new HashMap();

    public TrailHandler(class_1297 entity) {
        this.entity = entity;
    }

    public void tick() {
        List<TrailRenderer<?>> active = TrailHandler.getTrailRenderersFor(this.entity);
        for (TrailRenderer<?> renderer : active) {
            this.trails.putIfAbsent(renderer, new LinkedList());
        }
        HashMap toChange = new HashMap(this.trails);
        for (Map.Entry<TrailRenderer<?>, List<TrailSegmentEntity<?>>> entry : this.trails.entrySet()) {
            TrailRenderer<?> renderer = entry.getKey();
            List<TrailSegmentEntity<Object>> trails = entry.getValue();
            if (!trails.isEmpty()) {
                TrailSegmentEntity<?> last;
                if (active.contains(renderer) && (last = trails.get(trails.size() - 1)).method_19538().method_1022(this.entity.method_19538()) >= (double)(this.entity.method_17681() * renderer.getSpacing())) {
                    trails.add(this.spawnEntity(renderer));
                }
                trails = trails.stream().filter(class_1309::method_5805).collect(Collectors.toList());
            } else if (active.contains(renderer) && this.isMoving()) {
                trails.add(this.spawnEntity(renderer));
            }
            if (!active.contains(renderer) && trails.isEmpty()) {
                toChange.remove(renderer);
                continue;
            }
            toChange.put(renderer, trails);
        }
        this.trails = toChange;
    }

    private TrailSegmentEntity<?> spawnEntity(TrailRenderer<?> trailRenderer) {
        TrailSegmentEntity entity = new TrailSegmentEntity(this.entity, trailRenderer);
        Objects.requireNonNull(class_310.method_1551().field_1687).method_2942(0, entity);
        return entity;
    }

    public Map<TrailRenderer<?>, List<TrailSegmentEntity<?>>> getTrails() {
        return this.trails;
    }

    private boolean isMoving() {
        if (this.entity instanceof class_1309) {
            return this.entity.field_6014 != this.entity.method_23317() || this.entity.field_6036 != this.entity.method_23318() || this.entity.field_5969 != this.entity.method_23321();
        }
        return this.entity.method_18798().method_1033() != 0.0;
    }

    public static List<TrailRenderer<?>> getTrailRenderersFor(class_1297 entity) {
        ArrayList renderers = new ArrayList();
        if (!entity.method_5805()) {
            return renderers;
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            for (TrailRenderer renderer : AbilityUtil.getEnabledEntries(living, (Ability)Abilities.TRAIL.get()).stream().map(e -> TrailRendererManager.INSTANCE.getRenderer(e.getProperty(TrailAbility.TRAIL_RENDERER_ID))).filter(Objects::nonNull).distinct().toList()) {
                TrailHandler.addTrailToList(renderer, renderers);
            }
        }
        if (entity instanceof CustomProjectile) {
            CustomProjectile projectile = (CustomProjectile)entity;
            for (CustomProjectile.Appearance appearance : projectile.appearances) {
                if (!(appearance instanceof CustomProjectile.TrailAppearance)) continue;
                CustomProjectile.TrailAppearance trailAppearance = (CustomProjectile.TrailAppearance)appearance;
                for (class_2960 trailId : trailAppearance.trails) {
                    TrailRenderer<?> trailRenderer = TrailRendererManager.INSTANCE.getRenderer(trailId);
                    if (trailRenderer == null || renderers.contains(trailRenderer)) continue;
                    renderers.add(trailRenderer);
                }
            }
        }
        return renderers;
    }

    private static void addTrailToList(TrailRenderer<?> trailRenderer, List<TrailRenderer<?>> trailRendererList) {
        if (trailRenderer instanceof CompoundTrailRenderer) {
            CompoundTrailRenderer compound = (CompoundTrailRenderer)trailRenderer;
            for (TrailRenderer<?> renderer : compound.getTrailRenderers()) {
                TrailHandler.addTrailToList(renderer, trailRendererList);
            }
        } else if (!trailRendererList.contains(trailRenderer)) {
            trailRendererList.add(trailRenderer);
        }
    }
}

