/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.threetag.palladium.addonpack.parser.ArmorMaterialParser;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.item.PalladiumItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonArmorItem
extends class_1738
implements IAddonItem,
ArmorWithRenderer,
Openable,
PalladiumItem {
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;
    protected class_2960 rendererFile;
    private Object renderer;
    private boolean openable = false;
    private int openingTime = 0;
    private class_2960 openedSound;
    private class_2960 closedSound;
    private class_2960 toggleSound;

    public AddonArmorItem(class_1741 armorMaterial, class_1738.class_8051 type, class_1792.class_1793 properties) {
        super(armorMaterial, type, properties);
    }

    public AddonArmorItem setRenderer(class_2960 renderer) {
        this.rendererFile = renderer;
        return this;
    }

    public AddonArmorItem enableOpenable(boolean openable, int openingTime, class_2960 openedSound, class_2960 closedSound, class_2960 toggleSound) {
        this.openable = openable;
        this.openingTime = openingTime;
        this.openedSound = openedSound;
        this.closedSound = closedSound;
        this.toggleSound = toggleSound;
        return this;
    }

    @Override
    public void setCachedArmorRenderer(Object object) {
        this.renderer = object;
    }

    @Override
    public Object getCachedArmorRenderer() {
        return this.renderer;
    }

    @Override
    public class_2960 getArmorRendererFile() {
        return this.rendererFile != null ? this.rendererFile : ArmorWithRenderer.super.getArmorRendererFile();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    @NotNull
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    @Override
    public boolean canBeOpened(class_1309 entity, class_1799 stack) {
        return this.openable;
    }

    @Override
    public int getOpeningTime(class_1799 stack) {
        return this.openingTime;
    }

    @Override
    public void onFullyClosed(class_1309 entity, class_1799 stack) {
        if (this.closedSound != null) {
            PlayerUtil.playSoundToAll(entity.method_37908(), entity.method_23317(), entity.method_23320(), entity.method_23321(), 50.0, this.closedSound, class_3419.field_15248);
        }
    }

    @Override
    public void onFullyOpened(class_1309 entity, class_1799 stack) {
        if (this.closedSound != null) {
            PlayerUtil.playSoundToAll(entity.method_37908(), entity.method_23317(), entity.method_23320(), entity.method_23321(), 50.0, this.openedSound, class_3419.field_15248);
        }
    }

    @Override
    public void onOpeningStateChange(class_1309 entity, class_1799 stack, boolean open) {
        if (this.toggleSound != null) {
            PlayerUtil.playSoundToAll(entity.method_37908(), entity.method_23317(), entity.method_23320(), entity.method_23321(), 50.0, this.toggleSound, class_3419.field_15248);
        }
    }

    public void armorTick(class_1799 stack, class_1937 level, class_1657 player) {
        if (this.openable) {
            Openable.onTick((class_1309)player, stack);
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (this.openable && entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            Openable.onTick(living, stack);
        }
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            class_1741 armorMaterial = ArmorMaterialParser.getArmorMaterial(GsonUtil.getAsResourceLocation(json, "armor_material"));
            if (armorMaterial == null) {
                throw new JsonParseException("Unknown armor material '" + String.valueOf(GsonUtil.getAsResourceLocation(json, "armor_material")) + "'");
            }
            class_1738.class_8051 type = Parser.getArmorType(class_3518.method_15265((JsonObject)json, (String)"slot"));
            if (type == null) {
                throw new JsonParseException("Armor slot must be one of the following: " + Arrays.toString(Arrays.stream(class_1738.class_8051.values()).map(class_1738.class_8051::method_48400).toArray()));
            }
            AddonArmorItem item = new AddonArmorItem(armorMaterial, type, properties);
            item.rendererFile = GsonUtil.getAsResourceLocation(json, "armor_renderer", null);
            item.enableOpenable(class_3518.method_15258((JsonObject)json, (String)"openable", (boolean)false), GsonUtil.getAsIntMin(json, "opening_time", 0, 0), GsonUtil.getAsResourceLocation(json, "opened_sound", null), GsonUtil.getAsResourceLocation(json, "closed_sound", null), GsonUtil.getAsResourceLocation(json, "opening_toggle_sound", null));
            return item;
        }

        public static class_1738.class_8051 getArmorType(String name) {
            if (name.equalsIgnoreCase("head") || name.equalsIgnoreCase("helmet")) {
                return class_1738.class_8051.field_41934;
            }
            if (name.equalsIgnoreCase("chest") || name.equalsIgnoreCase("chestplate")) {
                return class_1738.class_8051.field_41935;
            }
            if (name.equalsIgnoreCase("legs") || name.equalsIgnoreCase("leggings")) {
                return class_1738.class_8051.field_41936;
            }
            if (name.equalsIgnoreCase("feet") || name.equalsIgnoreCase("boots")) {
                return class_1738.class_8051.field_41937;
            }
            return null;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Armor");
            builder.addProperty("slot", class_1738.class_8051.class).description("The slot the item will fit in. Possible values: " + Arrays.toString(Arrays.stream(class_1738.class_8051.values()).map(class_1738.class_8051::method_48400).toArray())).required().exampleJson((JsonElement)new JsonPrimitive("chest"));
            builder.addProperty("armor_material", class_1741.class).description("Armor material, which defines certain characteristics about the armor. Open armor_materials.html for seeing how to make custom ones. Possible values: " + Arrays.toString(ArmorMaterialParser.getIds().toArray(new class_2960[0]))).required().exampleJson((JsonElement)new JsonPrimitive("minecraft:diamond"));
            builder.addProperty("armor_renderer", class_2960.class).description("Location of the armor renderer file. Doesn't need to be specified, it will automatically look for one in a path corresponding to the item's ID: A 'test:item' will look for the armor renderer file at 'assets/test/palladium/armor_renderers/item.json'.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("test:item_renderer"));
            builder.addProperty("openable", Boolean.class).description("Marks the armor piece as openable.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("opening_time", Integer.class).description("Determines the time the item needs for it to be fully opened. Leave at 0 for instant. Needs 'openable' to be enabled to take effect.").fallback(0).exampleJson((JsonElement)new JsonPrimitive((Number)10));
            builder.addProperty("opened_sound", class_2960.class).description("Sound that is played when the suit has been fully opened.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:item.armor.equip_leather"));
            builder.addProperty("closed_sound", class_2960.class).description("Sound that is played when the suit has been fully closed.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:item.armor.equip_leather"));
            builder.addProperty("opening_toggle_sound", class_2960.class).description("Sound that is played when opening button has been pressed.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:item.armor.equip_leather"));
        }

        @Override
        public class_2960 getId() {
            return new class_2960("palladium", "armor");
        }
    }
}

