/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonCrossbowItem
extends class_1764
implements IAddonItem {
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;
    private final float velocityMultiplier;
    private final float inaccuracy;
    private final int useDuration;
    private final Predicate<class_1799> projectiles;
    @Nullable
    private final Predicate<class_1799> heldProjectiles;

    public AddonCrossbowItem(float velocityMultiplier, float inaccuracy, int useDuration, Predicate<class_1799> projectiles, @Nullable Predicate<class_1799> heldProjectiles, class_1792.class_1793 properties) {
        super(properties);
        this.velocityMultiplier = velocityMultiplier;
        this.inaccuracy = inaccuracy;
        this.useDuration = useDuration;
        this.projectiles = projectiles;
        this.heldProjectiles = heldProjectiles;
    }

    public int method_7881(class_1799 stack) {
        return this.useDuration;
    }

    public Predicate<class_1799> method_19268() {
        return this.projectiles;
    }

    public Predicate<class_1799> method_20310() {
        return this.heldProjectiles == null ? this.method_19268() : this.heldProjectiles;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        if (AddonCrossbowItem.method_7781((class_1799)itemStack)) {
            AddonCrossbowItem.method_7777((class_1937)level, (class_1309)player, (class_1268)usedHand, (class_1799)itemStack, (float)(AddonCrossbowItem.method_20309((class_1799)itemStack) * this.velocityMultiplier), (float)this.inaccuracy);
            AddonCrossbowItem.method_7782((class_1799)itemStack, (boolean)false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!player.method_18808(itemStack).method_7960()) {
            if (!AddonCrossbowItem.method_7781((class_1799)itemStack)) {
                this.field_7937 = false;
                this.field_7936 = false;
                player.method_6019(usedHand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            float velocityMultiplier = class_3518.method_15277((JsonObject)json, (String)"velocity_multiplier", (float)1.0f);
            float inaccuracy = class_3518.method_15277((JsonObject)json, (String)"inaccuracy", (float)1.0f);
            int useDuration = class_3518.method_15282((JsonObject)json, (String)"use_duration", (int)72000);
            class_6862 projectiles = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)GsonUtil.getAsResourceLocation(json, "projectiles", new class_2960("minecraft:arrows")));
            class_6862 heldProjectiles = json.has("held_projectiles") ? class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)GsonUtil.getAsResourceLocation(json, "held_projectiles")) : null;
            return new AddonCrossbowItem(velocityMultiplier, inaccuracy, useDuration, stack -> stack.method_31573(projectiles), heldProjectiles == null ? null : stack -> stack.method_31573(heldProjectiles), properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Crossbow");
            builder.addProperty("velocity_multiplier", Float.class).description("Velocity multiplier for the shot projectile, works differently to the bow one.").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("inaccuracy", Float.class).description("Inaccuracy for the shot projectile").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("use_duration", Integer.class).description("Amount of ticks the bow can be used for").fallback(72000).exampleJson((JsonElement)new JsonPrimitive((Number)72000));
            builder.addProperty("projectiles", class_2960.class).description("Item tag which contains all items that can be shot. By default all Minecraft arrows").fallback(new class_2960("arrows")).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
            builder.addProperty("held_projectiles", class_2960.class).description("Item tag which contains all items that can be shot by being in the off hand. Can be left out to fallback to the 'projectiles' option").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("crossbow");
        }
    }
}

