/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonProjectileItem
extends AddonItem {
    private final class_2960 entityTypeId;
    private final class_2487 entityData;

    public AddonProjectileItem(class_2960 entityTypeId, class_2487 entityData, class_1792.class_1793 properties) {
        super(properties);
        this.entityTypeId = entityTypeId;
        this.entityData = entityData;
    }

    @Nullable
    public class_1676 createProjectile(class_1937 level, class_1799 stack, class_1309 shooter) {
        class_1676 projectile;
        class_2487 compound = this.entityData == null ? new class_2487() : this.entityData;
        compound.method_10582("id", this.entityTypeId.toString());
        class_3218 world = (class_3218)shooter.method_37908();
        class_1297 entity = class_1299.method_17842((class_2487)compound, (class_1937)world, en -> {
            if (!(en instanceof class_1676)) {
                return null;
            }
            class_1676 projectile = (class_1676)en;
            projectile.method_5808(shooter.method_23317(), shooter.method_23318() + (double)shooter.method_5751() - 0.1, shooter.method_23321(), projectile.method_36454(), projectile.method_36455());
            projectile.method_7432((class_1297)shooter);
            return projectile;
        });
        return entity instanceof class_1676 ? (projectile = (class_1676)entity) : null;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            class_2960 entityTypeId = GsonUtil.getAsResourceLocation(json, "entity_type", Palladium.id("custom_projectile"));
            class_2487 entityData = null;
            if (json.has("entity_data")) {
                try {
                    entityData = class_2522.method_10718((String)class_3518.method_15295((JsonElement)json.get("entity_data"), (String)"entity_data").toString());
                }
                catch (CommandSyntaxException e) {
                    AddonPackLog.warning("Failed to read entity_data for projectile item: " + e.getMessage(), new Object[0]);
                }
            }
            return new AddonProjectileItem(entityTypeId, entityData, properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Projectile Item");
            builder.setDescription("If added to the item tag for a bow or a crossbow, this item type can used as ammunitation to shoot pre-defined projectiles.");
            builder.addProperty("entity_type", class_2960.class).description("ID of the entity type that should be shot. Only projectile entity works, like arrows, snowballs, or Palladium's custom projectile").fallback(Palladium.id("custom_projectile")).exampleJson((JsonElement)new JsonPrimitive(Palladium.id("custom_projectile").toString()));
            builder.addProperty("entity_data", class_2487.class).description("Custom NBT data for the shot entity").fallback(null).exampleJson((JsonElement)new JsonObject());
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("projectile");
        }
    }
}

