/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public interface Openable {
    public static final String OPEN_TAG = "Palladium:Opened";
    public static final String OPENING_TAG = "Palladium:Opening";

    default public boolean canBeOpened(class_1309 entity, class_1799 stack) {
        return true;
    }

    default public int getOpeningTime(class_1799 stack) {
        return 0;
    }

    default public void setOpen(class_1309 entity, class_1799 stack, boolean open) {
        if (!(entity.method_37908().field_9236 || this.isOpen(stack) == open || open && !this.canBeOpened(entity, stack))) {
            class_2487 nbt = stack.method_7948();
            nbt.method_10556(OPEN_TAG, open);
            this.onOpeningStateChange(entity, stack, open);
            if (this.getOpeningTime(stack) <= 0) {
                if (open) {
                    this.onFullyOpened(entity, stack);
                } else {
                    this.onFullyClosed(entity, stack);
                }
            }
        }
    }

    default public boolean isOpen(class_1799 stack) {
        return stack.method_7985() && Objects.requireNonNull(stack.method_7969()).method_10577(OPEN_TAG);
    }

    default public int getOpeningProgress(class_1799 stack) {
        return stack.method_7985() ? Objects.requireNonNull(stack.method_7969()).method_10550(OPENING_TAG) : 0;
    }

    default public void onOpeningStateChange(class_1309 entity, class_1799 stack, boolean open) {
    }

    default public void onFullyOpened(class_1309 entity, class_1799 stack) {
    }

    default public void onFullyClosed(class_1309 entity, class_1799 stack) {
    }

    public static void onTick(class_1309 entity, class_1799 stack) {
        class_1792 class_17922;
        if (!entity.method_37908().field_9236 && (class_17922 = stack.method_7909()) instanceof Openable) {
            Openable openable = (Openable)class_17922;
            class_2487 nbt = stack.method_7948();
            int max = openable.getOpeningTime(stack);
            if (max > 0) {
                int timer = nbt.method_10550(OPENING_TAG);
                boolean isOpen = openable.isOpen(stack);
                if (isOpen && !openable.canBeOpened(entity, stack)) {
                    isOpen = false;
                    nbt.method_10556(OPEN_TAG, isOpen);
                    openable.onOpeningStateChange(entity, stack, isOpen);
                }
                if (isOpen && timer < max) {
                    nbt.method_10569(OPENING_TAG, ++timer);
                    if (timer == max) {
                        openable.onFullyOpened(entity, stack);
                    }
                } else if (!isOpen && timer > 0) {
                    nbt.method_10569(OPENING_TAG, --timer);
                    if (timer == 0) {
                        openable.onFullyClosed(entity, stack);
                    }
                }
            }
        }
    }
}

