/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncAbilityStateMessage
extends MessageS2C {
    private final int entityId;
    private final AbilityReference reference;
    private final boolean unlocked;
    private final boolean enabled;
    private final int maxCooldown;
    private final int cooldown;
    private final int maxActivationTimer;
    private final int activationTimer;

    public SyncAbilityStateMessage(int entityId, AbilityReference reference, boolean unlocked, boolean enabled, int maxCooldown, int cooldown, int maxActivationTimer, int activationTimer) {
        this.entityId = entityId;
        this.reference = reference;
        this.unlocked = unlocked;
        this.enabled = enabled;
        this.maxCooldown = maxCooldown;
        this.cooldown = cooldown;
        this.maxActivationTimer = maxActivationTimer;
        this.activationTimer = activationTimer;
    }

    public SyncAbilityStateMessage(class_2540 buf) {
        this.entityId = buf.readInt();
        this.reference = AbilityReference.fromBuffer(buf);
        this.unlocked = buf.readBoolean();
        this.enabled = buf.readBoolean();
        this.maxCooldown = buf.readInt();
        this.cooldown = buf.readInt();
        this.maxActivationTimer = buf.readInt();
        this.activationTimer = buf.readInt();
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_ABILITY_STATE;
    }

    public void toBytes(class_2540 buf) {
        buf.writeInt(this.entityId);
        this.reference.toBuffer(buf);
        buf.writeBoolean(this.unlocked);
        buf.writeBoolean(this.enabled);
        buf.writeInt(this.maxCooldown);
        buf.writeInt(this.cooldown);
        buf.writeInt(this.maxActivationTimer);
        buf.writeInt(this.activationTimer);
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        class_1309 livingEntity;
        AbilityInstance entry;
        class_1297 entity = Objects.requireNonNull(class_310.method_1551().field_1687).method_8469(this.entityId);
        if (entity instanceof class_1309 && (entry = this.reference.getEntry(livingEntity = (class_1309)entity)) != null) {
            entry.setClientState(livingEntity, entry.getHolder(), this.unlocked, this.enabled, this.maxCooldown, this.cooldown, this.maxActivationTimer, this.activationTimer);
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof PowersScreen) {
                PowersScreen powers = (PowersScreen)class_4372;
                if (powers.selectedTab != null) {
                    powers.selectedTab.populate();
                }
            }
        }
    }
}

